/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import com.sugarcrm.sugarcrm.ListToSendByCxf;
import com.sugarcrm.sugarcrm.NameValue;
import com.sugarcrm.sugarcrm.SetRelationshipsRequestType;

import java.util.List;

public class SetRelationshipsRequest
{

    private SetRelationshipsRequestType bean;
    
    public SetRelationshipsRequest()
    {
        bean = new SetRelationshipsRequestType();
    }

    /**
     * Array of the name of the module that the primary record is from. 
     */
    public void setModuleNames(List<String> modules)
    {
        bean.setModuleNames(new ListToSendByCxf<String>().addElements(modules));
    }

    /**
     * The array of ID of the bean in the specified module_name 
     */
    public void setModuleIds(List<String> moduleIds)
    {
        bean.setModuleIds(new ListToSendByCxf<String>().addElements(moduleIds));
    }

    /**
     * Array of the name of the link field which relates to the other module 
     * for which the relationships needs to be generated. 
     */
    public void setLinkFieldNames(List<String> linkfieldsNames)
    {
        bean.setLinkFieldNames(new ListToSendByCxf<String>().addElements(linkfieldsNames));
    }

    /**
     * Array of an array of related record ids for which relationships needs to be generated 
     */
    public void setRelatedIds(List<String> relatedIds)
    {
        bean.setRelatedIds(new ListToSendByCxf<String>().addElements(relatedIds));
    }

    /**
     * Array of Array. The keys of the inner array are the SugarBean attributes, 
     * the values of the inner array are the values the attributes should have. 
     */
    public void setNameValueLists(List<NameValue> nameValues)
    {
        bean.setNameValueLists(new ListToSendByCxf<NameValue>().addElements(nameValues));
    }

    /**
     * Optional, array of 0 or 1. If the value 0 or nothing is passed then it will 
     * add the relationship for related_ids and if 1 is passed, it will delete this relationship for related_ids 
     */
    public void setDeleteArray(List<Integer> deleteds)
    {
        bean.setDeleteArray(new ListToSendByCxf<Integer>().addElements(deleteds));
    }

    public SetRelationshipsRequestType getBean()
    {
        return this.bean;
    }

}
