/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import com.sugarcrm.sugarcrm.ListToSendByCxf;
import com.sugarcrm.sugarcrm.NameValue;
import com.sugarcrm.sugarcrm.SetRelationshipRequestType;

import java.util.List;

public class SetRelationshipRequest
{

    private SetRelationshipRequestType bean;
    
    public SetRelationshipRequest()
    {
        bean = new SetRelationshipRequestType();
    }

    /**
     * Name of the module that the primary record is from
     */
    public void setModuleName(String value)
    {
        bean.setModuleName(value);
    }

    /**
     * The ID of the bean in the specified module_name 
     */
    public void setModuleId(String moduleId)
    {
        bean.setModuleId(moduleId);
    }

    /**
     * Name of the link field which relates to the other module for which the relationship needs to be generated
     */
    public void setLinkFieldName(String linkField)
    {
        bean.setLinkFieldName(linkField);
    }

    /**
     * Related record id for which relationship needs to be generated 
     */
    public void setRelatedId(String relatedId)
    {
        bean.setRelatedIds(relatedId);
    }

    /**
     * The keys of the array are the SugarBean attributes, the values of the array are the values the attributes should have. 
     */
    public void setNameValueList(List<NameValue> values)
    {
        bean.setNameValueList(new ListToSendByCxf<NameValue>().addElements(values));
    }

    /**
     * Optional, if the value 0 or nothing is passed then it will add the relationship for 
     * related_ids and if 1 is passed, it will delete this relationship for related_ids 
     */
    public void setDelete(int value)
    {
        bean.setDelete(value);
    }

    public SetRelationshipRequestType getBean()
    {
        return this.bean;
    }

}
