/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import com.sugarcrm.sugarcrm.ListToSendByCxf;
import com.sugarcrm.sugarcrm.NameValue;
import com.sugarcrm.sugarcrm.SetEntryRequestType;

import java.util.List;

public class SetEntryRequest
{

    private SetEntryRequestType bean;
    
    public SetEntryRequest()
    {
        bean = new SetEntryRequestType();
    }

    /**
     * The name of the module where created or updated entry  
     */
    public void setModuleName(String value)
    {
        bean.setModuleName(value);
    }

    /**
     * The keys of the array are the SugarBean attributes, the values 
     * of the array are the values the attributes should have. 
     */
    public void setNameValueList(List<NameValue> values)
    {
        bean.setNameValueList(new ListToSendByCxf<NameValue>().addElements(values));
    }

    public SetEntryRequestType getBean()
    {
        return this.bean;
    }

}
