/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import com.sugarcrm.sugarcrm.ListToSendByCxf;
import com.sugarcrm.sugarcrm.NameValue;
import com.sugarcrm.sugarcrm.SetEntriesRequestType;

import java.util.List;

public class SetEntriesRequest
{

    private SetEntriesRequestType bean = new SetEntriesRequestType();

    /**
     * The name of the module where created or updated entry  
     */
    public void setModuleName(String value)
    {
        bean.setModuleName(value);
    }

    /**
     * Array of Bean specific Arrays where the keys of the array are the SugarBean attributes, 
     * the values of the array are the values the attributes should have. 
     */
    public void setNameValueLists(List<List<NameValue>> values)
    {
        ListToSendByCxf<ListToSendByCxf<NameValue>> nameValuesList = new ListToSendByCxf<ListToSendByCxf<NameValue>>();
        for (List<NameValue> list : values)
        {
            nameValuesList.addElement(new ListToSendByCxf<NameValue>().addElements(list));
        }
        bean.setNameValueLists(nameValuesList);
    }

    public SetEntriesRequestType getBean()
    {
        return this.bean;
    }

}
