/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import org.mule.modules.sugarcrm.utils.SugarConstants;

import com.sugarcrm.sugarcrm.ListToSendByCxf;
import com.sugarcrm.sugarcrm.SearchByModuleRequestType;

import java.util.List;

public class SearchByModuleRequest
{

    private SearchByModuleRequestType bean;
    
    public SearchByModuleRequest()
    {
        bean = new SearchByModuleRequestType();
        bean.setSelectFields(new ListToSendByCxf<String>());
        bean.setMaxResults(SugarConstants.ALL_RESULTS);
        bean.setAssignedUserId("");
    }

    /**
     * String to search. 
     */
    public void setSearchString(String value)
    {
        bean.setSearchString(value);
    }

    /**
     * Array of modules to query
     */
    public void setModules(List<String> modules)
    {
        bean.setModules(new ListToSendByCxf<String>().addElements(modules));
    }

    /**
     * Set the first row to retrieve. If not set, rows will be retrieved beginnning from row 0
     */
    public void setOffset(int value)
    {
        bean.setOffset(value);
    }

    /**
     * Set the maximum number of rows + 1 to retrieve. If set -1 then retrieved all entries
     */
    public void setMaxResults(int value)
    {
        bean.setMaxResults(value);
    }

    /**
     * Set a user id to filter all records by, leave empty to exclude the filter
     */
    public void setAssignedUserId(String value)
    {
        bean.setAssignedUserId(value);
    }

    /**
     * An array of fields to return.  If empty the default return fields 
     * will be from the active list view defs.
     */
    public void setSelectFields(List<String> fields)
    {
        bean.setSelectFields(new ListToSendByCxf<String>().addElements(fields));
    }

    /**
     * A boolean indicating if we should only search against those modules 
     * participating in the unified search.
     */
    public void setUnifiedSearchOnly(boolean value)
    {
        bean.setUnifiedSearchOnly(value);
    }

    public SearchByModuleRequestType getBean()
    {
        return this.bean;
    }

}
