/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import com.sugarcrm.sugarcrm.GetModuleFieldsRequestType;
import com.sugarcrm.sugarcrm.ListToSendByCxf;

import java.util.List;

public class GetModuleFieldsRequest
{

    private GetModuleFieldsRequestType bean;

    public GetModuleFieldsRequest()
    {
        bean = new GetModuleFieldsRequestType();
    }

    /**
     * The name of the module to return records. 
     */
    public void setModuleName(String value)
    {
        bean.setModuleName(value);
    }

    /**
     * Optional, if passed then retrieve vardef information on these fields only. 
     */
    public void setFields(List<String> fields)
    {
        bean.setFields(new ListToSendByCxf<String>().addElements(fields));
    }

    public GetModuleFieldsRequestType getBean()
    {
        return this.bean;
    }

}
