/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import com.sugarcrm.sugarcrm.GetEntryRequestType;
import com.sugarcrm.sugarcrm.ListToSendByCxf;

import java.util.List;

public class GetEntryRequest
{

    private GetEntryRequestType bean;
    
    public GetEntryRequest()
    {
        bean = new GetEntryRequestType();
    }

    public GetEntryRequestType getBean()
    {
        return bean;
    }

    /**
     * The name of the module to return records from. 
     */
    public void setModuleName(String moduleName)
    {
        bean.setModuleName(moduleName);
    }

    /**
     * The SugarBean's ID value. 
     */
    public void setId(String id)
    {
        bean.setId(id);
    }

    /**
     * A list of the fields to be included in the results. 
     * This optional parameter allows for only needed fields to be retrieved. 
     */
    public void setSelectFields(List<String> fields)
    {
        bean.setSelectFields(new ListToSendByCxf<String>().addElements(fields));
    }

    /**
     * A list of link_names and for each link_name, what fields value to be returned 
     */
    public void setLinkNameToFieldsArray(List<String> links)
    {
        bean.setLinkNameToFieldsArray(new ListToSendByCxf<String>().addElements(links));
    }

    /**
     * Should we track the record accessed. 
     */
    public void setTrackView(boolean value)
    {
        bean.setTrackView(value);
    }
    
}


