/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import org.mule.modules.sugarcrm.utils.SugarConstants;

import com.sugarcrm.sugarcrm.GetEntryListRequestType;
import com.sugarcrm.sugarcrm.ListToSendByCxf;

import java.util.List;

public class GetEntryListRequest
{

    private GetEntryListRequestType bean;

    public GetEntryListRequest()
    {
        bean = new GetEntryListRequestType();
        bean.setQuery("");
        bean.setOrderBy("");
        bean.setMaxResults(SugarConstants.DEFAULT_SIZE_PAGE);
        bean.setSelectFields(new ListToSendByCxf<String>());
    }

    /**
     * The name of the module to return records from.  
     */
    public void setModuleName(String value)
    {
        bean.setModuleName(value);
    }

    /**
     * SQL where clause without the word 'where' 
     */
    public void setQuery(String value)
    {
        bean.setQuery(value);
    }

    /**
     * SQL order by clause without the phrase 'order by' 
     */
    public void setOrderBy(String value)
    {
        bean.setOrderBy(value);
    }

    /**
     * Set the first row to retrieve. If not set, rows will be retrieved beginnning from row 0
     */
    public void setOffset(int value)
    {
        bean.setOffset(value);
    }

    /**
     * Set the maximum number of rows + 1 to retrieve.
     */
    public void setMaxResults(int value)
    {
        bean.setMaxResults(value);
    }

    /**
     * A list of the fields to be included in the results. 
     * This optional parameter allows for only needed fields to be retrieved. 
     */
    public void setSelectFields(List<String> fields)
    {
        bean.setSelectFields(new ListToSendByCxf<String>().addElements(fields));
    }

    /**
     * A list of link_names and for each link_name, what fields value to be returned. 
     */
    public void setLinkNameToFieldsArray(List<String> linkNames)
    {
        bean.setLinkNameToFieldsArray(new ListToSendByCxf<String>().addElements(linkNames));
    }

    /**
     * 0 if deleted records should not be include, 1 if deleted records should be included. 
     */
    public void setDeleted(int value)
    {
        bean.setDeleted(value);
    }

    public GetEntryListRequestType getBean()
    {
        return this.bean;
    }

}
