/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.requests;

import com.sugarcrm.sugarcrm.GetEntriesRequestType;
import com.sugarcrm.sugarcrm.ListToSendByCxf;

import java.util.List;

public class GetEntriesRequest
{

    private GetEntriesRequestType bean;
    
    public GetEntriesRequest()
    {
        bean = new GetEntriesRequestType();
        bean.setSelectFields(new ListToSendByCxf<String>());
    }

    /**
     * The name of the module to return records.  
     */
    public void setModuleName(String value)
    {
        bean.setModuleName(value);
    }

    /**
     * An array of SugarBean IDs. 
     */
    public void setIds(List<String> ids)
    {
        bean.setIds(new ListToSendByCxf<String>().addElements(ids));
    }

    /**
     * A list of the fields to be included in the results. 
     * This optional parameter allows for only needed fields to be retrieved. 
     */
    public void setSelectFields(List<String> fields)
    {
        bean.setSelectFields(new ListToSendByCxf<String>().addElements(fields));
    }

    /**
     * A list of link_names and for each link_name, what fields value to be returned. 
     */
    public void setLinkNameToFieldsArray(List<String> linkNames)
    {
        bean.setLinkNameToFieldsArray(new ListToSendByCxf<String>().addElements(linkNames));
    }

    /**
     * Should we track the record accessed 
     */
    public void setTrackView(boolean value)
    {
        bean.setTrackView(value);
    }

    public GetEntriesRequestType getBean()
    {
        return this.bean;
    }

}
