/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.cxf.interceptors.transformer;

import org.apache.commons.lang.StringUtils;

/**
 * Transform a xml, adding namespace when is a item in array
 */
public class TransformerXMlSugarToCxfValid
{

    private static final String ITEM_WITH_SCHEMA = "<item xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:tns=\"http://www.sugarcrm.com/sugarcrm\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" ";
    
    public String transform(String aXml)
    {
        return StringUtils.replace(aXml, "<item ", ITEM_WITH_SCHEMA);
    }

}


