/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.cxf.interceptors;

import org.mule.modules.sugarcrm.cxf.interceptors.transformer.TransformerXMlSugarToCxfValid;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Interceptor that converts the array types to tags
 * 
 * @author Pablo Diez * @since 30/05/2012
 */
public class AddNamespacesForLaterUnmarshalInInterceptor extends AbstractPhaseInterceptor<Message>
{

    private static final Logger logger = LoggerFactory.getLogger(AddNamespacesForLaterUnmarshalInInterceptor.class);

    public AddNamespacesForLaterUnmarshalInInterceptor()
    {
        super(Phase.RECEIVE);
        addAfter(LoggingInInterceptor.class.getName());
    }

    /** @see org.apache.cxf.interceptor.Interceptor#handleMessage(org.apache.cxf.message.Message) */
    @Override
    public void handleMessage(Message message) throws Fault
    {
        try
        {
            String xml = IOUtils.toString(message.getContent(InputStream.class), "UTF-8");
            logger.trace("Response to Replace {}", xml);
            String xmlResult = new TransformerXMlSugarToCxfValid().transform(xml); 
            logger.trace("Result {}", xmlResult);
            ByteArrayInputStream responseStream = new ByteArrayInputStream(xmlResult.getBytes("UTF-8"));
            message.setContent(InputStream.class, responseStream);
        }
        catch (Exception e)
        {
            throw new UnhandledException(e);
        }
    }
}
