/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.api.exceptions;

import java.util.HashMap;
import java.util.Map;

public class FactorySugarExceptions
{

    private Map<String, Class<? extends RuntimeException>> exceptionsHandled = new HashMap<String, Class<? extends RuntimeException>>();

    public FactorySugarExceptions()
    {
        initExceptions();
    }

    private void initExceptions()
    {
        exceptionsHandled.put("Invalid Login", InvalidLoginException.class);
    }

    public RuntimeException with(Exception e)
    {
        String message = e.getMessage();

        if (exceptionsHandled.containsKey(message))
        {
            try
            {
                return exceptionsHandled.get(message).getDeclaredConstructor(String.class, Throwable.class).newInstance(message, e);
            }
            catch (Exception ex)
            {
                throw new RuntimeException(ex);
            }
        }
        else
        {
            return new RuntimeException(e);
        }
    }
}
