/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.api;

import org.mule.modules.sugarcrm.api.exceptions.FactorySugarExceptions;
import org.mule.modules.sugarcrm.cxf.interceptors.AddNamespacesForLaterUnmarshalInInterceptor;
import org.mule.modules.sugarcrm.cxf.interceptors.UnmarshalAnyElementsArrayInInterceptor;

import com.sugarcrm.sugarcrm.GetAvailableModulesRequestType;
import com.sugarcrm.sugarcrm.GetAvailableModulesResponseType;
import com.sugarcrm.sugarcrm.GetEntriesCountRequestType;
import com.sugarcrm.sugarcrm.GetEntriesCountResponseType;
import com.sugarcrm.sugarcrm.GetEntriesRequestType;
import com.sugarcrm.sugarcrm.GetEntriesResponseType;
import com.sugarcrm.sugarcrm.GetEntryListRequestType;
import com.sugarcrm.sugarcrm.GetEntryListResponseType;
import com.sugarcrm.sugarcrm.GetEntryRequestType;
import com.sugarcrm.sugarcrm.GetEntryResponseType;
import com.sugarcrm.sugarcrm.GetModuleFieldsRequestType;
import com.sugarcrm.sugarcrm.GetModuleFieldsResponseType;
import com.sugarcrm.sugarcrm.GetRelationshipsRequestType;
import com.sugarcrm.sugarcrm.GetRelationshipsResponseType;
import com.sugarcrm.sugarcrm.LoginRequestType;
import com.sugarcrm.sugarcrm.LoginResponseType;
import com.sugarcrm.sugarcrm.LogoutRequestType;
import com.sugarcrm.sugarcrm.LogoutResponseType;
import com.sugarcrm.sugarcrm.SearchByModuleRequestType;
import com.sugarcrm.sugarcrm.SearchByModuleResponseType;
import com.sugarcrm.sugarcrm.SetEntriesRequestType;
import com.sugarcrm.sugarcrm.SetEntriesResponseType;
import com.sugarcrm.sugarcrm.SetEntryRequestType;
import com.sugarcrm.sugarcrm.SetEntryResponseType;
import com.sugarcrm.sugarcrm.SetRelationshipRequestType;
import com.sugarcrm.sugarcrm.SetRelationshipResponseType;
import com.sugarcrm.sugarcrm.SetRelationshipsRequestType;
import com.sugarcrm.sugarcrm.SetRelationshipsResponseType;
import com.sugarcrm.sugarcrm.Sugarsoap;
import com.sugarcrm.sugarcrm.SugarsoapPortType;
import com.zauberlabs.commons.ws.connection.ConnectionBuilder;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;

public class SugarCrmClientSoap implements SugarCrmClient
{

    private SugarsoapPortType service;
    private final String endpoint;

    public SugarCrmClientSoap(String endpoint)
    {
        this.endpoint = endpoint;
    }

    @Override
    public LoginResponseType login(LoginRequestType request)
    {
        try
        {
            return getService().login(request);
        }
        catch (Exception e)
        {
            throw new FactorySugarExceptions().with(e);
        }
    }
    
    @Override
    public LogoutResponseType logout(LogoutRequestType request)
    {
        return getService().logout(request);
    }

    @Override
    public GetEntryResponseType getEntry(GetEntryRequestType request)
    {
        return getService().getEntry(request);
    }
    
    @Override
    public GetEntryListResponseType getEntryList(GetEntryListRequestType request)
    {
        return getService().getEntryList(request);
    }

    @Override
    public GetEntriesCountResponseType getCountEntries(GetEntriesCountRequestType request)
    {
        return getService().getEntriesCount(request);
    }

    @Override
    public GetEntriesResponseType getEntries(GetEntriesRequestType request)
    {
        return getService().getEntries(request);
    }

    @Override
    public SetEntryResponseType setEntry(SetEntryRequestType request)
    {
        return getService().setEntry(request);
    }

    @Override
    public SetEntriesResponseType setEntries(SetEntriesRequestType request)
    {
        return getService().setEntries(request);
    }

    @Override
    public GetModuleFieldsResponseType getModuleFields(GetModuleFieldsRequestType request)
    {
        return getService().getModuleFields(request);
    }

    @Override
    public GetAvailableModulesResponseType getAvailableModules(GetAvailableModulesRequestType request)
    {
        return getService().getAvailableModules(request);
    }
    
    @Override
    public SearchByModuleResponseType searchByModule(SearchByModuleRequestType request)
    {
        return getService().searchByModule(request);
    }
    
    @Override
    public SetRelationshipsResponseType setRelationships(SetRelationshipsRequestType request)
    {
        return getService().setRelationships(request);
    }

    @Override    
    public SetRelationshipResponseType setRelationship(SetRelationshipRequestType request)
    {
        return getService().setRelationship(request);
    }

    @Override
    public GetRelationshipsResponseType getRelationships(GetRelationshipsRequestType request)
    {
        return getService().getRelationships(request);
    }

    protected SugarsoapPortType getService()
    {
        if (service == null)
        {
            service = ConnectionBuilder.fromPortType(SugarsoapPortType.class)
                .withServiceType(Sugarsoap.class)
                .withPortQName(Sugarsoap.SugarsoapPort)
                .withClasspathWsdl("schema/sugarcrm.wsdl")
                .withEndpoint(endpoint)
                .build();

            final Client client = ClientProxy.getClient(service);
            client.getInInterceptors().add(new UnmarshalAnyElementsArrayInInterceptor());
            client.getInInterceptors().add(new AddNamespacesForLaterUnmarshalInInterceptor());
        }
        return service;
    }

}
