/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.modules.sugarcrm.api;

import com.sugarcrm.sugarcrm.GetAvailableModulesRequestType;
import com.sugarcrm.sugarcrm.GetAvailableModulesResponseType;
import com.sugarcrm.sugarcrm.GetEntriesCountRequestType;
import com.sugarcrm.sugarcrm.GetEntriesCountResponseType;
import com.sugarcrm.sugarcrm.GetEntriesRequestType;
import com.sugarcrm.sugarcrm.GetEntriesResponseType;
import com.sugarcrm.sugarcrm.GetEntryListRequestType;
import com.sugarcrm.sugarcrm.GetEntryListResponseType;
import com.sugarcrm.sugarcrm.GetEntryRequestType;
import com.sugarcrm.sugarcrm.GetEntryResponseType;
import com.sugarcrm.sugarcrm.GetModuleFieldsRequestType;
import com.sugarcrm.sugarcrm.GetModuleFieldsResponseType;
import com.sugarcrm.sugarcrm.GetRelationshipsRequestType;
import com.sugarcrm.sugarcrm.GetRelationshipsResponseType;
import com.sugarcrm.sugarcrm.LoginRequestType;
import com.sugarcrm.sugarcrm.LoginResponseType;
import com.sugarcrm.sugarcrm.LogoutRequestType;
import com.sugarcrm.sugarcrm.LogoutResponseType;
import com.sugarcrm.sugarcrm.SearchByModuleRequestType;
import com.sugarcrm.sugarcrm.SearchByModuleResponseType;
import com.sugarcrm.sugarcrm.SetEntriesRequestType;
import com.sugarcrm.sugarcrm.SetEntriesResponseType;
import com.sugarcrm.sugarcrm.SetEntryRequestType;
import com.sugarcrm.sugarcrm.SetEntryResponseType;
import com.sugarcrm.sugarcrm.SetRelationshipRequestType;
import com.sugarcrm.sugarcrm.SetRelationshipResponseType;
import com.sugarcrm.sugarcrm.SetRelationshipsRequestType;
import com.sugarcrm.sugarcrm.SetRelationshipsResponseType;

/**
 * The SugarCRM Client
 */
public interface SugarCrmClient
{

    /**
     * Logs the user into the Sugar application.
     */
    LoginResponseType login(LoginRequestType request);

    /**
     * Logs out the user from the current session. 
     */
    LogoutResponseType logout(LogoutRequestType request);
    
    /**
     * Retrieves a list of SugarBeans 
     */
    GetEntryListResponseType getEntryList(GetEntryListRequestType request);

    /**
     * Retrieves the specified number of records in a module. 
     */
    GetEntriesCountResponseType getCountEntries(GetEntriesCountRequestType request);

    /**
     * Retrieves multiple SugarBeans based on IDs. 
     */
    GetEntriesResponseType getEntries(GetEntriesRequestType request);

    /**
     * Creates or updates a single SugarBean.
     */
    SetEntryResponseType setEntry(SetEntryRequestType request);

    /**
     * Creates or updates a list of SugarBeans.
     */
    SetEntriesResponseType setEntries(SetEntriesRequestType request);

    /**
     * Retrieves the vardef information on fields of the specified bean. 
     */
    GetModuleFieldsResponseType getModuleFields(GetModuleFieldsRequestType request);

    /**
     * Retrieves the list of modules available to the current user logged into the system. 
     */
    GetAvailableModulesResponseType getAvailableModules(GetAvailableModulesRequestType request);

    /**
     * Returns the ID, module_name, and fields for the specified modules as specified in the search string.
     */
    SearchByModuleResponseType searchByModule(SearchByModuleRequestType request);

    /**
     * Sets a single relationship between two beans where items are related by module name and ID.
     */
    SetRelationshipResponseType setRelationship(SetRelationshipRequestType request);

    /**
     * Sets multiple relationships between two beans where items are related by module name and ID. 
     */
    SetRelationshipsResponseType setRelationships(SetRelationshipsRequestType request);

    /**
     * Retrieves a collection of beans that are related to the specified bean and, optionally, 
     * return relationship data for the related beans 
     */
    GetRelationshipsResponseType getRelationships(GetRelationshipsRequestType request);

    /**
     * Retrieves a single SugarBean based on ID
     */
    GetEntryResponseType getEntry(GetEntryRequestType request);

}
