/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package com.sugarcrm.sugarcrm;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlType
@XmlAccessorType(XmlAccessType.FIELD)
public class ListToSendByCxf<T>
{

    protected List<T> elements;
    @XmlAttribute(name = "arrayType", namespace = "http://schemas.xmlsoap.org/soap/encoding/")
    protected String arrayType = "";

    public ListToSendByCxf<T> addElements(List<T> elements)
    {
        getElements().addAll(elements);
        return this;
    }
    
    public ListToSendByCxf<T> addElement(T element)
    {
        getElements().add(element);
        return this;
    }

    public List<T> getElements()
    {
        if (elements == null)
        {
            elements = new ArrayList<T>();
        }
        return this.elements;
    }

}
