/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.events;

import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.extras.spring.events.MuleEventListener;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class AsynchronousEventListener
implements MuleEventListener {
    protected static final Log logger = LogFactory.getLog((Class)AsynchronousEventListener.class);
    private final ApplicationListener listener;
    private final ExecutorService threadPool;

    public AsynchronousEventListener(ExecutorService threadPool, ApplicationListener listener) {
        this.threadPool = threadPool;
        this.listener = listener;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        try {
            this.threadPool.execute((Runnable)new Worker(this.listener, event));
        }
        catch (RejectedExecutionException e) {
            logger.error((Object)("Failed to execute worker for event: " + event.toString()), (Throwable)e);
        }
    }

    public ApplicationListener getListener() {
        return this.listener;
    }

    private static class Worker
    implements Runnable {
        private final ApplicationListener listener;
        private final ApplicationEvent event;

        public Worker(ApplicationListener listener, ApplicationEvent event) {
            this.listener = listener;
            this.event = event;
        }

        public void run() {
            try {
                this.listener.onApplicationEvent(this.event);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to forward event: " + this.event.toString()), (Throwable)e);
            }
        }
    }
}

