/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MuleResourceLoader
extends DefaultResourceLoader {
    protected transient Log logger = LogFactory.getLog((Class)MuleResourceLoader.class);

    protected Resource getResourceByPath(String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to load resource from file system: " + r.getFile().getAbsolutePath()));
        }
        if (r.exists()) {
            return r;
        }
        this.logger.debug((Object)"Resource does not exist on file system, loading from classpath.");
        r = new ClassPathResource(path, this.getClassLoader());
        return r;
    }
}

