/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.io.IOException;
import org.mule.extras.spring.config.MuleBeanDefinitionReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class MuleApplicationContext
extends AbstractXmlApplicationContext {
    private final Resource[] configResources;
    private final String[] configLocations;

    public MuleApplicationContext(Resource[] configResources) {
        this(configResources, true);
    }

    public MuleApplicationContext(Resource[] configResources, boolean refresh) throws BeansException {
        this.configResources = configResources;
        this.configLocations = null;
        if (refresh) {
            this.refresh();
        }
    }

    public MuleApplicationContext(String[] configLocations) {
        this(configLocations, true);
    }

    public MuleApplicationContext(String[] configLocations, boolean refresh) throws BeansException {
        this.configLocations = configLocations;
        this.configResources = null;
        if (refresh) {
            this.refresh();
        }
    }

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        MuleBeanDefinitionReader beanDefinitionReader = new MuleBeanDefinitionReader((BeanDefinitionRegistry)beanFactory, this.configResources != null ? this.configResources.length : this.configLocations.length);
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }
}

