/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.StringUtils;
import org.mule.util.XMLUtils;
import org.w3c.dom.Element;

public class SpringXMLUtils
extends XMLUtils {
    private static final Log logger = LogFactory.getLog(SpringXMLUtils.class);
    public static final String MULE_DEFAULT_NAMESPACE = "http://www.mulesource.org/schema/mule/core";
    public static final String MULE_NAMESPACE_PREFIX = "http://www.mulesource.org/schema/mule/";

    public static boolean isMuleNamespace(Element element) {
        String ns = element.getNamespaceURI();
        return ns != null && ns.startsWith(MULE_NAMESPACE_PREFIX);
    }

    public static boolean isBeansNamespace(Element element) {
        String ns = element.getNamespaceURI();
        return ns != null && ns.equals("http://www.springframework.org/schema/beans");
    }

    public static String getNameOrId(Element element) {
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        if (StringUtils.isBlank((String)id)) {
            if (StringUtils.isBlank((String)name)) {
                return "";
            }
            return name;
        }
        if (!StringUtils.isBlank((String)name) && !name.equals(id)) {
            logger.warn((Object)("Id (" + id + ") and name (" + name + ") differ for " + SpringXMLUtils.elementToString((Element)element)));
        }
        return id;
    }
}

