/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.splunk.connectivity;

import com.wsl.modules.splunk.adapters.SplunkConnectorLicenseChecker;
import com.wsl.modules.splunk.connectivity.SplunkConnectorConnectionKey;
import com.wsl.modules.splunk.connectivity.SplunkConnectorConnectionManager;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(SplunkConnectorConnectionFactory.class);
    private SplunkConnectorConnectionManager connectionManager;

    public SplunkConnectorConnectionFactory(SplunkConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof SplunkConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("com.wsl.modules.splunk.connectivity.SplunkConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        SplunkConnectorLicenseChecker connector = new SplunkConnectorLicenseChecker();
        connector.setHost(this.connectionManager.getHost());
        connector.setPort(this.connectionManager.getPort());
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((SplunkConnectorConnectionKey)key).getUsername(), ((SplunkConnectorConnectionKey)key).getPassword());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SplunkConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("com.wsl.modules.splunk.connectivity.SplunkConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof SplunkConnectorLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("com.wsl.modules.splunk.adapters.SplunkConnectorLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((SplunkConnectorLicenseChecker)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((SplunkConnectorLicenseChecker)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((SplunkConnectorLicenseChecker)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof SplunkConnectorLicenseChecker)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("com.wsl.modules.splunk.adapters.SplunkConnectorLicenseChecker")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((SplunkConnectorLicenseChecker)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof SplunkConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof SplunkConnectorLicenseChecker)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((SplunkConnectorLicenseChecker)obj).isConnected()) {
            ((SplunkConnectorLicenseChecker)obj).connect(((SplunkConnectorConnectionKey)key).getUsername(), ((SplunkConnectorConnectionKey)key).getPassword());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

