/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.splunk;

import com.splunk.CollectionArgs;
import com.splunk.InputKind;
import com.splunk.SavedSearchDispatchArgs;
import com.wsl.modules.splunk.OutputMode;
import com.wsl.modules.splunk.SearchMode;
import com.wsl.modules.splunk.SplunkClient;
import com.wsl.modules.splunk.exception.SplunkConnectorException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.ConnectionException;
import org.mule.api.callback.SourceCallback;

public class SplunkConnector {
    private String host;
    private String port;
    private SplunkClient splunkClient;

    public SplunkClient getSplunkClient() {
        return this.splunkClient;
    }

    public void setSplunkClient(SplunkClient splunkClient) {
        this.splunkClient = splunkClient;
    }

    public void connect(String username, String password) throws ConnectionException {
        this.splunkClient = new SplunkClient(this);
        this.splunkClient.connect(username, password, this.getHost(), this.getPort());
    }

    public void disconnect() {
        this.splunkClient = null;
    }

    public boolean isConnected() {
        return this.splunkClient != null && this.splunkClient.getService().getToken() != null;
    }

    public String getConnectionIdentifier() {
        if (this.splunkClient.getService() != null) {
            return this.splunkClient.getService().getToken();
        }
        return "001";
    }

    public List<Map<String, Object>> getApplications() {
        return this.splunkClient.getApplications();
    }

    public List<Map<String, Object>> getJobs() {
        return this.splunkClient.getJobs();
    }

    public void runNormalSearch(String searchQuery, Map<String, Object> searchArgs, SourceCallback searchCallback) throws SplunkConnectorException {
        this.splunkClient.runNormalSearch(searchQuery, searchArgs, searchCallback);
    }

    public Map<String, Object> runBlockingSearch(String searchQuery, Map<String, Object> searchArgs) throws SplunkConnectorException {
        return this.splunkClient.runBlockingSearch(searchQuery, searchArgs);
    }

    public List<Map<String, Object>> runOneShotSearch(String searchQuery, String earliestTime, String latestTime, Map<String, String> args) throws SplunkConnectorException {
        return this.splunkClient.runOneShotSearch(searchQuery, earliestTime, latestTime, args);
    }

    public List<Map<String, Object>> getSavedSearches(String app, String owner) {
        return this.splunkClient.getSavedSearches(app, owner);
    }

    public Map<String, Object> createSavedSearch(String searchName, String searchQuery, Map<String, Object> searchArgs) {
        return this.splunkClient.createSavedSearch(searchName, searchQuery, searchArgs);
    }

    public Set<Map.Entry<String, Object>> viewSavedSearchProperties(String searchName, String app, String owner) {
        return this.splunkClient.viewSavedSearchProperties(searchName, app, owner);
    }

    public Map<String, Object> modifySavedSearchProperties(String searchName, Map<String, Object> searchProperties) throws SplunkConnectorException {
        return this.splunkClient.modifySavedSearchProperties(searchName, searchProperties);
    }

    public List<Map<String, Object>> getSavedSearchHistory(String searchName, String app, String owner) {
        return this.splunkClient.getSavedSearchHistory(searchName, app, owner);
    }

    public List<Map<String, Object>> runSavedSearch(String searchName) throws SplunkConnectorException {
        return this.splunkClient.runSavedSearch(searchName);
    }

    public List<Map<String, Object>> runSavedSearchWithArguments(String searchName, Map<String, Object> customArgs, SavedSearchDispatchArgs searchDispatchArgs) throws SplunkConnectorException {
        return this.splunkClient.runSavedSearchWithArguments(searchName, customArgs, searchDispatchArgs);
    }

    public boolean deleteSavedSearch(String searchName) {
        return this.splunkClient.deleteSavedSearch(searchName);
    }

    public Map<String, Object> getDataModel(String dataModelName) {
        return this.splunkClient.getDataModel(dataModelName);
    }

    public List<Map<String, Object>> getDataModels() {
        return this.splunkClient.getDataModels();
    }

    public void runRealTimeSearch(String searchQuery, String earliestTime, String latestTime, int statusBuckets, int previewCount, SourceCallback callback) throws SplunkConnectorException {
        this.splunkClient.runRealTimeSearch(searchQuery, earliestTime, latestTime, statusBuckets, previewCount, callback);
    }

    public void runExportSearch(String searchQuery, String earliestTime, String latestTime, SourceCallback callback) throws SplunkConnectorException {
        this.splunkClient.runExportSearch(searchQuery, earliestTime, latestTime, SearchMode.NORMAL, OutputMode.JSON, callback);
    }

    public List<Map<String, Object>> getInputs() {
        return this.splunkClient.getInputs();
    }

    public Map<String, Object> createInput(String inputIdentifier, InputKind kind, Map<String, Object> args) {
        return this.splunkClient.createInput(inputIdentifier, kind, args);
    }

    public Map<String, Object> modifyInput(String inputIdentifier, Map<String, Object> inputArgs) {
        return this.splunkClient.modifyInput(inputIdentifier, inputArgs);
    }

    public Map<String, Object> getInput(String inputIdentifier) {
        return this.splunkClient.getInput(inputIdentifier);
    }

    public List<Map<String, Object>> getIndexes(String sortKey, CollectionArgs.SortDirection sortDirection, Map<String, Object> collectionParameters) {
        return this.splunkClient.getIndexes(sortKey, sortDirection, collectionParameters);
    }

    public Map<String, Object> createIndex(String indexName, Map<String, Object> args) {
        return this.splunkClient.createIndex(indexName, args);
    }

    public Map<String, Object> modifyIndex(String indexName, Map<String, Object> indexArgs) {
        return this.splunkClient.modifyIndex(indexName, indexArgs);
    }

    public Map<String, Object> getIndex(String indexIdentifier) {
        return this.splunkClient.getIndex(indexIdentifier);
    }

    public Map<String, Object> cleanIndex(String indexName, int maxSeconds) {
        return this.splunkClient.cleanIndex(indexName, maxSeconds);
    }

    public Map<String, Object> addDataToIndex(String indexName, String stringData, Map<String, Object> indexArgs) {
        return this.splunkClient.addDataToIndex(indexName, stringData, indexArgs);
    }

    public Boolean addDataToTcpInput(String portNumber, String stringData) throws SplunkConnectorException {
        return this.splunkClient.addDataToTcpInput(portNumber, stringData);
    }

    public Boolean addDataToUdpInput(String portNumber, String stringData) throws SplunkConnectorException {
        return this.splunkClient.addDataToUdpInput(portNumber, stringData);
    }

    public Boolean removeInput(String inputIdentifier) {
        return this.splunkClient.removeInput(inputIdentifier);
    }

    public Boolean removeIndex(String indexName) {
        return this.splunkClient.removeIndex(indexName);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

