/*
 * Decompiled with CFR 0.152.
 */
package com.wsl.modules.splunk;

import com.splunk.Application;
import com.splunk.Args;
import com.splunk.CollectionArgs;
import com.splunk.DataModel;
import com.splunk.DataModelCollection;
import com.splunk.Event;
import com.splunk.HttpException;
import com.splunk.Index;
import com.splunk.IndexCollection;
import com.splunk.IndexCollectionArgs;
import com.splunk.Input;
import com.splunk.InputCollection;
import com.splunk.InputKind;
import com.splunk.Job;
import com.splunk.JobArgs;
import com.splunk.JobExportArgs;
import com.splunk.JobResultsArgs;
import com.splunk.JobResultsPreviewArgs;
import com.splunk.MultiResultsReaderJson;
import com.splunk.MultiResultsReaderXml;
import com.splunk.ResultsReader;
import com.splunk.ResultsReaderJson;
import com.splunk.ResultsReaderXml;
import com.splunk.SavedSearch;
import com.splunk.SavedSearchCollection;
import com.splunk.SavedSearchDispatchArgs;
import com.splunk.SearchResults;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import com.splunk.TcpInput;
import com.splunk.UdpInput;
import com.wsl.modules.splunk.OutputMode;
import com.wsl.modules.splunk.SearchMode;
import com.wsl.modules.splunk.SplunkConnector;
import com.wsl.modules.splunk.exception.SplunkConnectorException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.modeshape.common.text.Inflector;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.callback.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplunkClient.class);
    private SplunkConnector splunkConnector;
    private Service service;

    public SplunkClient(SplunkConnector splunkConnector) {
        this.splunkConnector = splunkConnector;
    }

    public void connect(String username, String password, String host, String port) throws ConnectionException {
        if (username == null || password == null || host == null || port == null || !this.isInt(port) || username.isEmpty() || password.isEmpty() || host.isEmpty() || port.isEmpty()) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "00", "Invalid credentials");
        }
        try {
            ServiceArgs loginArgs = new ServiceArgs();
            loginArgs.setUsername(username);
            loginArgs.setPassword(password);
            loginArgs.setHost(host);
            loginArgs.setPort(Integer.parseInt(port));
            this.service = Service.connect((Map)loginArgs);
        }
        catch (HttpException splunkException) {
            LOGGER.error("HTTPException Connecting to Splunk", (Throwable)splunkException);
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN_HOST, Integer.toString(splunkException.getStatus()), splunkException.getMessage());
        }
        catch (RuntimeException e) {
            LOGGER.info("Error connecting to Splunk", (Throwable)e);
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN_HOST, "00", e.getMessage());
        }
        catch (Exception e) {
            LOGGER.info("Error connnecting to Splunk", (Throwable)e);
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN_HOST, "00", e.getMessage());
        }
    }

    public List<Map<String, Object>> getApplications() {
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>();
        for (Application app : this.service.getApplications().values()) {
            Set set = app.entrySet();
            HashMap mapFromSet = new HashMap();
            for (Map.Entry entry : set) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            returnList.add(mapFromSet);
        }
        return returnList;
    }

    public List<Map<String, Object>> getSavedSearches(String app, String owner) {
        SavedSearchCollection savedSearches;
        ArrayList<Map<String, Object>> savedSearchList = new ArrayList<Map<String, Object>>();
        ServiceArgs namespace = new ServiceArgs();
        if (app != null || owner != null) {
            namespace.setApp(app);
            namespace.setOwner(owner);
            savedSearches = this.service.getSavedSearches((Args)namespace);
        } else {
            savedSearches = this.service.getSavedSearches();
        }
        for (SavedSearch entity : savedSearches.values()) {
            Set set = entity.entrySet();
            HashMap mapFromSet = new HashMap();
            for (Map.Entry entry : set) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            savedSearchList.add(mapFromSet);
        }
        return savedSearchList;
    }

    public Map<String, Object> createSavedSearch(String searchName, String searchQuery, Map<String, Object> searchArgs) {
        Validate.notEmpty((String)searchName, (String)"Search Name empty.");
        Validate.notEmpty((String)searchQuery, (String)"Search Query empty.");
        SavedSearch createdSearch = searchArgs != null && !searchArgs.isEmpty() ? this.service.getSavedSearches().create(searchName, searchQuery, searchArgs) : this.service.getSavedSearches().create(searchName, searchQuery);
        Set set = createdSearch.entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public SavedSearch getSavedSearch(String searchName, String app, String owner) {
        ServiceArgs namespace = new ServiceArgs();
        namespace.setOwner(owner);
        namespace.setApp(app);
        Validate.notEmpty((String)searchName, (String)"Search Name empty.");
        return (SavedSearch)this.service.getSavedSearches((Args)namespace).get((Object)searchName);
    }

    public Set<Map.Entry<String, Object>> viewSavedSearchProperties(String searchName, String app, String owner) {
        ServiceArgs namespace = new ServiceArgs();
        if (owner != null) {
            namespace.setOwner(owner);
        }
        if (app != null) {
            namespace.setApp(app);
        }
        Validate.notEmpty((String)searchName, (String)"Search Name empty.");
        return ((SavedSearch)this.service.getSavedSearches((Args)namespace).get((Object)searchName)).entrySet();
    }

    public Map<String, Object> modifySavedSearchProperties(String searchName, Map<String, Object> searchProperties) throws SplunkConnectorException {
        Validate.notEmpty((String)searchName, (String)"You must provide a search name to modify");
        Validate.notNull(searchProperties, (String)"You must provide some properties to modify");
        Validate.notEmpty(searchProperties, (String)"You must provide some properties to modify");
        SavedSearch savedSearch = (SavedSearch)this.service.getSavedSearches().get((Object)searchName);
        savedSearch.update(searchProperties);
        Set set = savedSearch.entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public List<Map<String, Object>> getSavedSearchHistory(String searchName, String app, String owner) {
        ArrayList jobList = new ArrayList();
        ServiceArgs namespace = new ServiceArgs();
        if (app != null || owner != null) {
            namespace.setApp(app);
            namespace.setOwner(owner);
        }
        if (searchName == null || searchName.isEmpty()) {
            SavedSearchCollection savedSearches = this.service.getSavedSearches((Args)namespace);
            for (SavedSearch entity : savedSearches.values()) {
                Collections.addAll(jobList, entity.history());
            }
        } else {
            SavedSearch savedSearch = (SavedSearch)this.service.getSavedSearches((Args)namespace).get((Object)searchName);
            Validate.notNull((Object)savedSearch, (String)"SavedSearch doesn't exist.");
            Collections.addAll(jobList, savedSearch.history());
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Job entity : jobList) {
            Set set = entity.entrySet();
            HashMap mapFromSet = new HashMap();
            for (Map.Entry entry : set) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            result.add(mapFromSet);
        }
        return result;
    }

    public List<Map<String, Object>> runSavedSearch(String searchName) throws SplunkConnectorException {
        SavedSearch savedSearch = (SavedSearch)this.service.getSavedSearches().get((Object)searchName);
        try {
            Job job = savedSearch.dispatch();
            while (!job.isDone()) {
                Thread.sleep(500L);
            }
            return this.populateEventResponse(job);
        }
        catch (InterruptedException e) {
            throw new SplunkConnectorException(e.getMessage(), e);
        }
    }

    public List<Map<String, Object>> runSavedSearchWithArguments(String searchName, Map<String, Object> customArgs, SavedSearchDispatchArgs searchDispatchArgs) throws SplunkConnectorException {
        SavedSearch savedSearch = (SavedSearch)this.service.getSavedSearches().get((Object)searchName);
        SavedSearchDispatchArgs notNullSearchDispatchArgs = new SavedSearchDispatchArgs();
        if (searchDispatchArgs != null) {
            notNullSearchDispatchArgs.putAll((Map)searchDispatchArgs);
        }
        if (customArgs != null) {
            String queryParams = "";
            for (Map.Entry<String, Object> entry : customArgs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                queryParams = queryParams + " " + key + "=$args." + key + "$";
                notNullSearchDispatchArgs.add("args." + key, (Object)value);
            }
        }
        try {
            Job job = savedSearch.dispatch(notNullSearchDispatchArgs);
            while (!job.isDone()) {
                Thread.sleep(500L);
            }
            return this.populateEventResponse(job);
        }
        catch (InterruptedException e) {
            LOGGER.info("Saved Search run interrupted", (Throwable)e);
            throw new SplunkConnectorException(e.getMessage(), e);
        }
    }

    protected List<Map<String, Object>> populateEventResponse(Job job) throws SplunkConnectorException {
        JobResultsArgs resultsArgs = new JobResultsArgs();
        resultsArgs.setOutputMode(JobResultsArgs.OutputMode.JSON);
        InputStream results = job.getResults(resultsArgs);
        try {
            ResultsReaderJson resultsReader = new ResultsReaderJson(results);
            return this.parseEvents((ResultsReader)resultsReader);
        }
        catch (IOException e) {
            throw new SplunkConnectorException(e.getMessage(), e);
        }
    }

    protected List<Map<String, Object>> parseEvents(ResultsReader resultsReader) throws SplunkConnectorException {
        ArrayList<Map<String, Object>> searchResponseList = new ArrayList<Map<String, Object>>();
        try {
            Event event;
            while ((event = resultsReader.getNextEvent()) != null) {
                HashMap eventData = new HashMap();
                for (Map.Entry entry : event.entrySet()) {
                    eventData.put(this.convertToJavaConvention((String)entry.getKey()), entry.getValue());
                }
                searchResponseList.add(eventData);
            }
            resultsReader.close();
            return searchResponseList;
        }
        catch (IOException e) {
            throw new SplunkConnectorException(e.getMessage(), e);
        }
    }

    public boolean deleteSavedSearch(String searchName) {
        try {
            SavedSearch savedSearch = (SavedSearch)this.service.getSavedSearches().get((Object)searchName);
            savedSearch.remove();
            return true;
        }
        catch (HttpException e) {
            LOGGER.info("Exception occurred deleting saved search", (Throwable)e);
            return false;
        }
    }

    public Map<String, Object> getDataModel(String dataModelName) {
        Validate.notNull((Object)dataModelName, (String)"You must provide a data model name");
        Validate.notEmpty((String)dataModelName, (String)"You must provide a data model name");
        DataModelCollection dataModelCollection = this.service.getDataModels();
        Set set = ((DataModel)dataModelCollection.get((Object)dataModelName)).entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public List<Map<String, Object>> getDataModels() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (DataModel model : this.service.getDataModels().values()) {
            HashMap mapFromSet = new HashMap();
            for (Map.Entry entry : model.entrySet()) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            result.add(mapFromSet);
        }
        return result;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public List<Map<String, Object>> getJobs() {
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>();
        for (Job job : this.service.getJobs().values()) {
            Set set = job.entrySet();
            HashMap mapFromSet = new HashMap();
            for (Map.Entry entry : set) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            returnList.add(mapFromSet);
        }
        return returnList;
    }

    public void runNormalSearch(String searchQuery, Map<String, Object> searchArgs, SourceCallback searchCallback) throws SplunkConnectorException {
        Validate.notEmpty((String)searchQuery, (String)"Search Query is empty.");
        JobArgs jobArgs = new JobArgs();
        jobArgs.putAll(searchArgs);
        jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
        Job job = this.service.getJobs().create(searchQuery, jobArgs);
        while (!job.isDone()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new SplunkConnectorException("Polling for Normal Search results was interrupted", e);
            }
        }
        HashMap<String, Object> searchResponse = new HashMap<String, Object>();
        searchResponse.put("job", job);
        searchResponse.put("events", this.populateEventResponse(job));
        try {
            searchCallback.process(searchResponse);
        }
        catch (Exception e) {
            throw new SplunkConnectorException(e.getMessage(), e);
        }
    }

    public Map<String, Object> runBlockingSearch(String searchQuery, Map<String, Object> searchArgs) throws SplunkConnectorException {
        Validate.notEmpty((String)searchQuery, (String)"Search Query is empty.");
        JobArgs jobArgs = new JobArgs();
        jobArgs.putAll((Map)jobArgs);
        jobArgs.setExecutionMode(JobArgs.ExecutionMode.BLOCKING);
        Job job = this.service.getJobs().create(searchQuery, jobArgs);
        HashMap<String, Object> searchResponse = new HashMap<String, Object>();
        searchResponse.put("job", job);
        searchResponse.put("events", this.populateEventResponse(job));
        return searchResponse;
    }

    public List<Map<String, Object>> runOneShotSearch(String searchQuery, String earliestTime, String latestTime, Map<String, String> args) throws SplunkConnectorException {
        Args oneshotSearchArgs = new Args();
        oneshotSearchArgs.put((Object)"earliest_time", (Object)earliestTime);
        oneshotSearchArgs.put((Object)"latest_time", (Object)latestTime);
        if (args != null) {
            for (Map.Entry<String, String> entry : args.entrySet()) {
                oneshotSearchArgs.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        InputStream resultsOneshot = this.service.oneshotSearch(searchQuery, oneshotSearchArgs);
        try {
            ResultsReaderXml resultsReader = new ResultsReaderXml(resultsOneshot);
            return this.parseEvents((ResultsReader)resultsReader);
        }
        catch (IOException e) {
            throw new SplunkConnectorException(e.getMessage(), e);
        }
    }

    public void runRealTimeSearch(String searchQuery, String earliestTime, String latestTime, int statusBuckets, int previewCount, SourceCallback callback) throws SplunkConnectorException {
        JobArgs jobArgs = new JobArgs();
        jobArgs.setExecutionMode(JobArgs.ExecutionMode.NORMAL);
        jobArgs.setSearchMode(JobArgs.SearchMode.REALTIME);
        jobArgs.setEarliestTime(earliestTime);
        jobArgs.setLatestTime(latestTime);
        jobArgs.setStatusBuckets(statusBuckets);
        JobResultsPreviewArgs previewArgs = new JobResultsPreviewArgs();
        previewArgs.setCount(previewCount);
        previewArgs.setOutputMode(JobResultsPreviewArgs.OutputMode.JSON);
        Job job = this.service.search(searchQuery, (Map)jobArgs);
        while (!job.isReady()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                job.finish();
                throw new SplunkConnectorException(e.getMessage(), e);
            }
        }
        while (true) {
            InputStream results = job.getResultsPreview(previewArgs);
            try {
                ResultsReaderJson resultsReader = new ResultsReaderJson(results);
                callback.process(this.parseEvents((ResultsReader)resultsReader));
                results.close();
                resultsReader.close();
            }
            catch (Exception e) {
                job.cancel();
                throw new SplunkConnectorException(e.getMessage(), e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                job.finish();
                throw new SplunkConnectorException(e.getMessage(), e);
            }
        }
    }

    public void runExportSearch(String searchQuery, String earliestTime, String latestTime, SearchMode searchMode, OutputMode outputMode, SourceCallback callback) throws SplunkConnectorException {
        JobExportArgs newExportArgs = new JobExportArgs();
        newExportArgs.setEarliestTime(earliestTime);
        newExportArgs.setLatestTime(latestTime);
        if (searchMode == SearchMode.NORMAL) {
            newExportArgs.setSearchMode(JobExportArgs.SearchMode.NORMAL);
        } else {
            newExportArgs.setSearchMode(JobExportArgs.SearchMode.REALTIME);
        }
        if (outputMode == OutputMode.JSON) {
            newExportArgs.setOutputMode(JobExportArgs.OutputMode.JSON);
        } else {
            newExportArgs.setOutputMode(JobExportArgs.OutputMode.XML);
        }
        ArrayList<SearchResults> searchResultsList = new ArrayList<SearchResults>();
        InputStream exportSearch = this.service.export(searchQuery, newExportArgs);
        try {
            if (outputMode == OutputMode.JSON) {
                MultiResultsReaderJson multiResultsReader = new MultiResultsReaderJson(exportSearch);
                for (SearchResults searchResults : multiResultsReader) {
                    searchResultsList.add(searchResults);
                }
                callback.process(searchResultsList);
                multiResultsReader.close();
            } else {
                MultiResultsReaderXml multiResultsReader = new MultiResultsReaderXml(exportSearch);
                for (SearchResults searchResults : multiResultsReader) {
                    searchResultsList.add(searchResults);
                }
                callback.process(searchResultsList);
                multiResultsReader.close();
            }
        }
        catch (IOException e) {
            throw new SplunkConnectorException(e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new SplunkConnectorException("Error processing callback", ex);
        }
    }

    public List<Map<String, Object>> getInputs() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Input input : this.service.getInputs().values()) {
            HashMap mapFromSet = new HashMap();
            for (Map.Entry entry : input.entrySet()) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            result.add(mapFromSet);
        }
        return result;
    }

    protected String convertToJavaConvention(String key) {
        return Inflector.getInstance().lowerCamelCase(key, new char[0]).replace("_", "");
    }

    public Map<String, Object> createInput(String inputIdentifier, InputKind kind, Map<String, Object> args) {
        InputCollection myInputs = this.service.getInputs();
        Input input = args != null && !args.isEmpty() ? myInputs.create(inputIdentifier, kind, args) : myInputs.create(inputIdentifier, kind);
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : input.entrySet()) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public Map<String, Object> modifyInput(String inputIdentifier, Map<String, Object> inputArgs) {
        Validate.notNull(inputArgs, (String)"You must provide some properties to modify");
        Validate.notEmpty(inputArgs, (String)"You must provide some properties to modify");
        Input input = this.service.getInputs().get((Object)inputIdentifier);
        input.update(inputArgs);
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : input.entrySet()) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public Map<String, Object> getInput(String inputIdentifier) {
        Validate.notNull((Object)inputIdentifier, (String)"You must provide a valid input identifier");
        Validate.notEmpty((String)inputIdentifier, (String)"You must provide a valid input identifier");
        Input input = this.service.getInputs().get((Object)inputIdentifier);
        Validate.notNull((Object)input, (String)"You must provide a valid input identifier");
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : input.entrySet()) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public List<Map<String, Object>> getIndexes(String sortKey, CollectionArgs.SortDirection sortDirection, Map<String, Object> collectionParameters) {
        IndexCollectionArgs args = new IndexCollectionArgs();
        if (sortKey != null && !sortKey.isEmpty()) {
            args.setSortKey(sortKey);
        }
        if (sortDirection != null) {
            args.setSortDirection(sortDirection);
        }
        if (collectionParameters != null && !collectionParameters.isEmpty()) {
            args.putAll(collectionParameters);
        }
        IndexCollection coll = args.isEmpty() ? this.service.getIndexes() : this.service.getIndexes(args);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Index index : coll.values()) {
            Set set = index.entrySet();
            HashMap mapFromSet = new HashMap();
            for (Map.Entry entry : set) {
                mapFromSet.put(entry.getKey(), entry.getValue());
            }
            result.add(mapFromSet);
        }
        return result;
    }

    public Map<String, Object> createIndex(String indexName, Map<String, Object> args) {
        Index index = args != null && !args.isEmpty() ? (Index)this.service.getIndexes().create(indexName, args) : (Index)this.service.getIndexes().create(indexName);
        Set set = index.entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public Map<String, Object> modifyIndex(String indexName, Map<String, Object> indexArgs) {
        Validate.notNull(indexArgs, (String)"You must provide some properties to modify");
        Validate.notEmpty(indexArgs, (String)"You must provide some properties to modify");
        Index index = (Index)this.service.getIndexes().get((Object)indexName);
        index.update(indexArgs);
        Set set = index.entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public Map<String, Object> getIndex(String indexIdentifier) {
        Index index = (Index)this.service.getIndexes().get((Object)indexIdentifier);
        Validate.notNull((Object)index, (String)"You must provide a valid index name");
        Set set = index.entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public Map<String, Object> cleanIndex(String indexName, int maxSeconds) {
        Validate.notNull((Object)indexName, (String)"You must provide an index name");
        Validate.notEmpty((String)indexName, (String)"You must provide an index name");
        Index index = (Index)this.service.getIndexes().get((Object)indexName);
        index = index.clean(maxSeconds);
        Set set = index.entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public Map<String, Object> addDataToIndex(String indexName, String stringData, Map<String, Object> indexArgs) {
        Index index = (Index)this.service.getIndexes().get((Object)indexName);
        if (indexArgs != null && !indexArgs.isEmpty()) {
            Args eventArgs = new Args();
            eventArgs.putAll(indexArgs);
            index.submit(eventArgs, stringData);
        } else {
            index.submit(stringData);
        }
        Set set = index.entrySet();
        HashMap<String, Object> mapFromSet = new HashMap<String, Object>();
        for (Map.Entry entry : set) {
            mapFromSet.put((String)entry.getKey(), entry.getValue());
        }
        return mapFromSet;
    }

    public Boolean addDataToTcpInput(String portNumber, String stringData) throws SplunkConnectorException {
        InputCollection coll = this.service.getInputs();
        TcpInput input = (TcpInput)coll.get((Object)portNumber);
        try {
            input.submit(stringData);
            return true;
        }
        catch (IOException e) {
            LOGGER.info("Unable to submit to that TCP Port", (Throwable)e);
            return false;
        }
    }

    public Boolean addDataToUdpInput(String portNumber, String data) throws SplunkConnectorException {
        UdpInput input = (UdpInput)this.service.getInputs().get((Object)portNumber);
        try {
            input.submit(data);
            return true;
        }
        catch (IOException e) {
            LOGGER.info("Unable to submit to that TCP Port", (Throwable)e);
            return false;
        }
    }

    public Boolean removeInput(String inputIdentifier) {
        Input input = this.service.getInputs().get((Object)inputIdentifier);
        input.remove();
        return true;
    }

    public Boolean removeIndex(String indexName) {
        IndexCollection coll = this.service.getIndexes();
        Index index = (Index)coll.get((Object)indexName);
        index.remove();
        return true;
    }

    boolean isInt(String str) {
        return str.matches("^-?\\d+$");
    }
}

