/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.shiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.subject.WebSubject;
import org.mule.api.MuleMessage;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityException;
import org.mule.module.shiro.ShiroAuthentication;
import org.mule.module.shiro.ShiroAuthenticationResult;
import org.mule.security.AbstractSecurityProvider;

public class ShiroAuthenticationProvider
extends AbstractSecurityProvider {
    private SecurityManager securityManager;
    private boolean rememberMe;

    public ShiroAuthenticationProvider() {
        super("shiro");
    }

    public Authentication authenticate(Authentication authentication) throws SecurityException {
        Subject subject;
        AuthenticationToken token = authentication instanceof ShiroAuthentication ? ((ShiroAuthentication)authentication).getToken() : this.createShiroToken(authentication);
        MuleMessage message = authentication.getEvent().getMessage();
        HttpServletRequest req = (HttpServletRequest)message.getInvocationProperty("http.servlet.request");
        if (req != null && this.securityManager instanceof WebSecurityManager) {
            HttpServletResponse res = (HttpServletResponse)message.getInvocationProperty("http.servlet.response");
            subject = new WebSubject.Builder(this.securityManager, (ServletRequest)req, (ServletResponse)res).buildWebSubject();
        } else {
            subject = new Subject.Builder(this.securityManager).buildSubject();
        }
        subject.login(token);
        return new ShiroAuthenticationResult(subject, authentication.getProperties(), authentication.getEvent());
    }

    protected AuthenticationToken createShiroToken(Authentication authentication) {
        UsernamePasswordToken token = new UsernamePasswordToken((String)authentication.getPrincipal(), authentication.getCredentials().toString().toCharArray());
        token.setRememberMe(this.rememberMe);
        return token;
    }

    public void setDelegate(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public SecurityManager getDelegate() {
        return this.securityManager;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }
}

