/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.shiro;

import java.util.Collection;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.api.transport.PropertyScope;
import org.mule.module.shiro.AuthorizationFilter;
import org.mule.transport.http.filters.HttpBasicAuthenticationFilter;
import org.springframework.util.AntPathMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUrlPatternFilter
extends HttpBasicAuthenticationFilter {
    private String urlPattern;
    private Collection<String> permissions;
    private Collection<String> roles;
    private String unauthorizedUrl;
    private String loginUrl;
    private AuthorizationFilter authorizationFilter;
    private AntPathMatcher matcher = new AntPathMatcher();

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.authorizationFilter = new AuthorizationFilter();
        this.authorizationFilter.setPermissions(this.permissions);
        this.authorizationFilter.setRoles(this.roles);
        this.authorizationFilter.setSecurityManager(this.getSecurityManager());
        this.authorizationFilter.setMuleContext(this.muleContext);
        this.authorizationFilter.setSecurityProviders(this.getSecurityProviders());
        this.authorizationFilter.initialise();
    }

    protected boolean applies(MuleEvent event) {
        MuleMessage message = event.getMessage();
        return this.matcher.match(this.urlPattern, (String)message.getProperty("http.request", PropertyScope.INBOUND));
    }

    public void doFilter(MuleEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        if (this.applies(event)) {
            super.doFilter(event);
            this.authorizationFilter.doFilter(event);
        }
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public Collection<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> requiredPermissions) {
        this.permissions = requiredPermissions;
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<String> requiredRoles) {
        this.roles = requiredRoles;
    }

    public String getUnauthorizedUrl() {
        return this.unauthorizedUrl;
    }

    public void setUnauthorizedUrl(String unauthorizedUrl) {
        this.unauthorizedUrl = unauthorizedUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }
}

