/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.shiro;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.NotPermittedException;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityFilter;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.module.shiro.ShiroAuthenticationResult;
import org.mule.security.AbstractSecurityFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationFilter
extends AbstractSecurityFilter {
    private Collection<String> permissions;
    private Collection<String> roles;

    public void doFilter(MuleEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
        Authentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (!(auth instanceof ShiroAuthenticationResult)) {
            throw new UnknownAuthenticationTypeException(auth);
        }
        ShiroAuthenticationResult shiroAuth = (ShiroAuthenticationResult)auth;
        try {
            Collection<String> roles;
            Collection<Permission> permissions = this.getPermissions(event);
            if (permissions != null) {
                shiroAuth.getSubject().checkPermissions(permissions);
            }
            if ((roles = this.getRoles(event)) != null) {
                DelegatingSubject subj = (DelegatingSubject)shiroAuth.getSubject();
                subj.getSecurityManager().checkRoles(subj.getPrincipals(), roles.toArray(new String[0]));
            }
        }
        catch (UnauthorizedException e) {
            throw new NotPermittedException(event, event.getSession().getSecurityContext(), (SecurityFilter)this);
        }
    }

    protected Collection<Permission> getPermissions(MuleEvent event) {
        ArrayList<Permission> p2 = new ArrayList<Permission>();
        if (this.permissions != null) {
            for (String name : this.permissions) {
                p2.add((Permission)new WildcardPermission(name));
            }
        }
        return p2;
    }

    protected Collection<String> getRoles(MuleEvent event) {
        return this.roles;
    }

    public Collection<String> getPermissions() {
        return this.permissions;
    }

    public void setRoles(Collection<String> roles) {
        this.roles = roles;
    }

    public void setPermissions(Collection<String> permissions) {
        this.permissions = permissions;
    }
}

