/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.schedulers.cron;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.concurrent.Latch;

public class MultipleSchedulersTestCase
extends FunctionalTestCase {
    private static CountDownLatch firstRequest = new CountDownLatch(2);
    private static Latch stoppedFlowLatch = new Latch();
    private static int counter = 0;

    protected String getConfigFile() {
        return "multiple-schedulers-config.xml";
    }

    @Test
    public void schedulersAreNotSharedAcrossPollers() throws Exception {
        firstRequest.await(this.getTestTimeoutSecs(), TimeUnit.SECONDS);
        Flow poll1 = (Flow)muleContext.getRegistry().lookupFlowConstruct("poll1");
        poll1.stop();
        stoppedFlowLatch.countDown();
        PollingProber pollingProber = new PollingProber(5000L, 100L);
        pollingProber.check(new Probe(){

            public boolean isSatisfied() {
                return counter == 2;
            }

            public String describeFailure() {
                return "Poll2 was not executed after stopping Poll1 flow";
            }
        });
    }

    public static class SynchronizedPollExecutionCounter {
        public Object process(Object payload) throws InterruptedException {
            if ("poll2".equals(payload)) {
                counter++;
            }
            firstRequest.countDown();
            stoppedFlowLatch.await();
            return payload;
        }
    }
}

