/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.schedulers.cron;

import java.util.Collection;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.Schedulers;
import org.mule.modules.schedulers.cron.CronScheduler;
import org.mule.tck.junit4.FunctionalTestCase;

public class CronsTimeZoneSchedulerTest
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "cron-timezone-scheduler-config.xml";
    }

    @Test
    public void timeZoneInScheduler() throws Exception {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)"pollWithTimeZone"));
        Assert.assertThat((Object)schedulers, (Matcher)IsCollectionWithSize.hasSize((int)1));
        for (Scheduler scheduler : schedulers) {
            Assert.assertThat((Object)scheduler, (Matcher)CoreMatchers.instanceOf(CronScheduler.class));
            Assert.assertThat((Object)((CronScheduler)scheduler).getTimeZone(), (Matcher)CoreMatchers.is((Object)TimeZone.getTimeZone("America/Argentina/Buenos_Aires")));
        }
    }

    @Test
    public void invalidTimeZoneInScheduler() throws Exception {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)"pollWithInvalidTimeZone"));
        Assert.assertThat((Object)schedulers, (Matcher)IsCollectionWithSize.hasSize((int)1));
        for (Scheduler scheduler : schedulers) {
            Assert.assertThat((Object)scheduler, (Matcher)CoreMatchers.instanceOf(CronScheduler.class));
            Assert.assertThat((Object)((CronScheduler)scheduler).getTimeZone(), (Matcher)CoreMatchers.is((Object)TimeZone.getTimeZone("GMT")));
        }
    }
}

