/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.schedulers.cron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.Schedulers;
import org.mule.tck.junit4.FunctionalTestCase;

public class CronsSchedulerTest
extends FunctionalTestCase {
    private static List<String> foo = new ArrayList<String>();
    private static List<String> bar = new ArrayList<String>();

    @BeforeClass
    public static void setProperties() {
        System.setProperty("expression.property", "0/1 * * * * ?");
    }

    protected String getConfigFile() {
        return "cron-scheduler-config.xml";
    }

    @Test
    public void test() throws Exception {
        this.waitForPollElements();
        this.checkForFooCollectionToBeFilled();
        this.checkForBarCollectionToBeFilled();
        this.stopSchedulers();
        this.waitForPollElements();
        int fooElementsAfterStopping = foo.size();
        this.waitForPollElements();
        Assert.assertEquals((long)fooElementsAfterStopping, (long)foo.size());
        this.runSchedulersOnce();
        this.waitForPollElements();
        Assert.assertEquals((long)(fooElementsAfterStopping + 1), (long)foo.size());
    }

    private void waitForPollElements() throws InterruptedException {
        Thread.sleep(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForFooCollectionToBeFilled() {
        List<String> list = foo;
        synchronized (list) {
            foo.size();
            Assert.assertTrue((foo.size() > 0 ? 1 : 0) != 0);
            for (String s : foo) {
                Assert.assertEquals((Object)"foo", (Object)s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForBarCollectionToBeFilled() {
        List<String> list = bar;
        synchronized (list) {
            bar.size();
            Assert.assertTrue((bar.size() > 0 ? 1 : 0) != 0);
            for (String s : bar) {
                Assert.assertEquals((Object)"bar", (Object)s);
            }
        }
    }

    private void runSchedulersOnce() throws Exception {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)"pollfoo"));
        for (Scheduler scheduler : schedulers) {
            scheduler.schedule();
        }
    }

    private void stopSchedulers() throws MuleException {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.flowConstructPollingSchedulers((String)"pollfoo"));
        for (Scheduler scheduler : schedulers) {
            scheduler.stop();
        }
    }

    public static class BarComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(String s) {
            List list = bar;
            synchronized (list) {
                if (bar.size() < 10) {
                    bar.add(s);
                    return true;
                }
            }
            return false;
        }
    }

    public static class FooComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(String s) {
            List list = foo;
            synchronized (list) {
                if (foo.size() < 10) {
                    foo.add(s);
                    return true;
                }
            }
            return false;
        }
    }
}

