/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.schedulers.cron;

import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.modules.schedulers.cron.CronScheduler;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.PollingReceiverWorker;

public class CronSchedulerTest
extends AbstractMuleContextTestCase {
    private AbstractPollingMessageReceiver receiver = (AbstractPollingMessageReceiver)Mockito.mock(AbstractPollingMessageReceiver.class);
    private InboundEndpoint endpoint = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
    private Prober pollingProber = new PollingProber(1000L, 0L);

    @Before
    public void setExpects() {
        Mockito.when((Object)this.receiver.getEndpoint()).thenReturn((Object)this.endpoint);
        Mockito.when((Object)this.receiver.getReceiverKey()).thenReturn((Object)"receiverKey");
        Mockito.when((Object)this.endpoint.getName()).thenReturn((Object)"endpointName");
    }

    @Test
    public void validateLifecycleHappyPath() throws MuleException {
        CronScheduler scheduler = this.createVoidScheduler();
        scheduler.initialise();
        scheduler.start();
        scheduler.stop();
        scheduler.dispose();
    }

    @Test
    public void stopAfterInitializeShouldNotFail() throws MuleException {
        CronScheduler scheduler = this.createVoidScheduler();
        scheduler.initialise();
        scheduler.stop();
    }

    @Test
    public void startAfterStopShouldNotFail() throws Exception {
        final TestPollingWorker job = new TestPollingWorker(this.receiver);
        CronScheduler scheduler = this.createScheduler(job);
        scheduler.initialise();
        scheduler.start();
        scheduler.stop();
        scheduler.start();
        Assert.assertFalse((boolean)job.wasRun);
        scheduler.schedule();
        this.pollingProber.check(new Probe(){

            public boolean isSatisfied() {
                return job.wasRun;
            }

            public String describeFailure() {
                return "The scheduler was never run";
            }
        });
    }

    private CronScheduler createVoidScheduler() {
        CronScheduler scheduler = new CronScheduler("name", new PollingReceiverWorker(this.receiver), "0/1 * * * * ?", TimeZone.getDefault());
        scheduler.setMuleContext(muleContext);
        return scheduler;
    }

    private CronScheduler createScheduler(PollingReceiverWorker job) {
        CronScheduler cronScheduler = new CronScheduler("name", job, "0/1 * * * * ?", TimeZone.getDefault());
        cronScheduler.setMuleContext(muleContext);
        return cronScheduler;
    }

    private class TestPollingWorker
    extends PollingReceiverWorker {
        boolean wasRun;

        public TestPollingWorker(AbstractPollingMessageReceiver pollingMessageReceiver) {
            super(pollingMessageReceiver);
        }

        public void run() {
            this.wasRun = true;
        }
    }
}

