/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.schedulers.cron;

import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.modules.schedulers.cron.CronJob;
import org.mule.modules.schedulers.i18n.SchedulerMessages;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.polling.schedule.PollScheduler;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class CronScheduler
extends PollScheduler<PollingReceiverWorker>
implements MuleContextAware {
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String THREAD_POLL_CLASS_PROPERTY = "org.quartz.threadPool.class";
    public static final String THREAD_POLL_CLASS = "org.quartz.simpl.SimpleThreadPool";
    public static final String THREAD_POOL_COUNT_PROPERTY = "org.quartz.threadPool.threadCount";
    public static final String POLL_CRON_SCHEDULER_JOB = "poll.scheduler.job";
    public static final String QUARTZ_INSTANCE_NAME_PROPERTY = "org.quartz.scheduler.instanceName";
    private Scheduler quartzScheduler;
    private MuleContext context;
    private String cronExpression;
    private TimeZone timeZone;
    private String jobName;
    private String groupName;

    public CronScheduler(String name, PollingReceiverWorker job, String cronExpression, TimeZone timeZone) {
        super(name, (Runnable)job);
        this.cronExpression = cronExpression;
        this.timeZone = timeZone;
    }

    public void schedule() throws Exception {
        this.quartzScheduler.triggerJob(JobKey.jobKey((String)this.jobName, (String)this.groupName));
    }

    public void dispose() {
        try {
            this.quartzScheduler.shutdown();
        }
        catch (SchedulerException e) {
            this.logger.error((Object)SchedulerMessages.couldNotShutdownScheduler(), (Throwable)e);
        }
    }

    public void initialise() throws InitialisationException {
        try {
            this.quartzScheduler = this.createScheduler();
            this.jobName = ((PollingReceiverWorker)this.job).getReceiver().getReceiverKey();
            this.groupName = ((PollingReceiverWorker)this.job).getReceiver().getEndpoint().getName();
            this.quartzScheduler.addJob(this.jobDetail(this.jobName, this.groupName, (PollingReceiverWorker)this.job), true);
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            throw new InitialisationException(SchedulerMessages.couldNotCreateScheduler(), (Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        try {
            if (this.quartzScheduler.isStarted()) {
                if (this.quartzScheduler.getTrigger(TriggerKey.triggerKey((String)this.getName(), (String)this.groupName)) == null) {
                    CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.getName(), this.groupName).forJob(this.jobName, this.groupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cronExpression).inTimeZone(this.timeZone)).build();
                    this.quartzScheduler.scheduleJob((Trigger)cronTrigger);
                } else {
                    this.quartzScheduler.resumeAll();
                }
            }
        }
        catch (SchedulerException e) {
            throw new DefaultMuleException(SchedulerMessages.couldNotScheduleJob(), (Throwable)e);
        }
    }

    public void stop() throws MuleException {
        try {
            this.quartzScheduler.pauseAll();
        }
        catch (SchedulerException e) {
            throw new DefaultMuleException(SchedulerMessages.couldNotPauseSchedulers(), (Throwable)e);
        }
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setMuleContext(MuleContext context) {
        this.context = context;
    }

    public boolean isStarted() throws MuleException {
        try {
            return this.quartzScheduler.isStarted();
        }
        catch (SchedulerException e) {
            throw new DefaultMuleException(SchedulerMessages.couldNotGetSchedulerStatus(), (Throwable)e);
        }
    }

    private JobDetail jobDetail(String jobName, String groupName, PollingReceiverWorker job) {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(POLL_CRON_SCHEDULER_JOB, (Object)job);
        return JobBuilder.newJob(CronJob.class).storeDurably().withIdentity(jobName, groupName).usingJobData(jobDataMap).build();
    }

    private Scheduler createScheduler() throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory(this.withFactoryProperties());
        return factory.getScheduler();
    }

    private Properties withFactoryProperties() {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty(QUARTZ_INSTANCE_NAME_PROPERTY, this.context.getConfiguration().getId() + "-" + this.name);
        factoryProperties.setProperty(THREAD_POLL_CLASS_PROPERTY, THREAD_POLL_CLASS);
        factoryProperties.setProperty(THREAD_POOL_COUNT_PROPERTY, String.valueOf(this.context.getDefaultMessageReceiverThreadingProfile().getMaxThreadsActive()));
        return factoryProperties;
    }
}

