/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.schedulers.cron;

import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerFactory;
import org.mule.modules.schedulers.cron.CronScheduler;
import org.mule.transport.PollingReceiverWorker;

public class CronSchedulerFactory
extends SchedulerFactory<PollingReceiverWorker> {
    private static final Log logger = LogFactory.getLog(CronSchedulerFactory.class);
    private static final String TZ_GMT_ID = "GMT";
    private String expression;
    private String timeZone;

    protected Scheduler doCreate(String name, PollingReceiverWorker job) {
        CronScheduler cronScheduler = new CronScheduler(name, job, this.expression, this.resolveTimeZone(name));
        cronScheduler.setMuleContext(this.context);
        return cronScheduler;
    }

    protected TimeZone resolveTimeZone(String name) {
        TimeZone resolvedTimeZone;
        TimeZone timeZone = resolvedTimeZone = this.timeZone == null ? TimeZone.getDefault() : TimeZone.getTimeZone(this.timeZone);
        if (!TZ_GMT_ID.equals(this.timeZone) && resolvedTimeZone.equals(TimeZone.getTimeZone(TZ_GMT_ID))) {
            logger.warn((Object)String.format("Configured timezone '%s' is invalid in scheduler '%s'. Defaulting to %s", this.timeZone, name, TZ_GMT_ID));
        }
        return resolvedTimeZone;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }
}

