
package org.mule.module.s3.connectivity;

import javax.annotation.Generated;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.module.s3.adapters.S3ConnectorConnectionIdentifierAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-04-29T02:59:39-05:00", comments = "Build UNNAMED.1373.24989b8")
public class S3ConnectorConnectionFactory implements KeyedPoolableObjectFactory
{

    private static Logger logger = LoggerFactory.getLogger(S3ConnectorConnectionFactory.class);
    private S3ConnectorConnectionManager connectionManager;

    public S3ConnectorConnectionFactory(S3ConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key)
        throws Exception
    {
        if (!(key instanceof S3ConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        S3ConnectorConnectionIdentifierAdapter connector = new S3ConnectorConnectionIdentifierAdapter();
        connector.setProxyUsername(connectionManager.getProxyUsername());
        connector.setProxyPort(connectionManager.getProxyPort());
        connector.setProxyPassword(connectionManager.getProxyPassword());
        connector.setProxyHost(connectionManager.getProxyHost());
        connector.setSocketTimeout(connectionManager.getSocketTimeout());
        connector.setConnectionTimeout(connectionManager.getConnectionTimeout());
        if (connector instanceof Initialisable) {
            ((Initialisable) connector).initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware) connector).setMuleContext(connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            ((Startable) connector).start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj)
        throws Exception
    {
        if (!(key instanceof S3ConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof S3ConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((S3ConnectorConnectionIdentifierAdapter) obj).disconnect();
        } catch (Exception e) {
            throw e;
        } finally {
            if (((S3ConnectorConnectionIdentifierAdapter) obj) instanceof Stoppable) {
                ((Stoppable) obj).stop();
            }
            if (((S3ConnectorConnectionIdentifierAdapter) obj) instanceof Disposable) {
                ((Disposable) obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof S3ConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((S3ConnectorConnectionIdentifierAdapter) obj).isConnected();
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj)
        throws Exception
    {
        if (!(key instanceof S3ConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof S3ConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            if (!((S3ConnectorConnectionIdentifierAdapter) obj).isConnected()) {
                ((S3ConnectorConnectionIdentifierAdapter) obj).connect(((S3ConnectorConnectionKey) key).getAccessKey(), ((S3ConnectorConnectionKey) key).getSecretKey());
            }
        } catch (Exception e) {
            throw e;
        }
    }

    public void passivateObject(Object key, Object obj)
        throws Exception
    {
    }

}
