/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.processors;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.s3.S3Connector;
import org.mule.module.s3.exception.ExceptionDecorator;
import org.mule.module.s3.exception.S3ClientException;
import org.mule.module.s3.model.UploadPartResult;
import org.mule.security.oauth.callback.ProcessCallback;

public class UploadPartMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object bucketName;
    protected String _bucketNameType;
    protected Object key;
    protected String _keyType;
    protected Object uploadId;
    protected String _uploadIdType;
    protected Object partNumber;
    protected Integer _partNumberType;
    protected Object partSize;
    protected Long _partSizeType;
    protected Object md5Digest;
    protected String _md5DigestType;
    protected Object content;
    protected InputStream _contentType;
    protected Object file;
    protected File _fileType;
    protected Object fileOffset;
    protected Long _fileOffsetType;
    protected Object isLastPart;
    protected boolean _isLastPartType;

    public UploadPartMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setContent(Object value) {
        this.content = value;
    }

    public void setFileOffset(Object value) {
        this.fileOffset = value;
    }

    public void setMd5Digest(Object value) {
        this.md5Digest = value;
    }

    public void setPartSize(Object value) {
        this.partSize = value;
    }

    public void setUploadId(Object value) {
        this.uploadId = value;
    }

    public void setFile(Object value) {
        this.file = value;
    }

    public void setBucketName(Object value) {
        this.bucketName = value;
    }

    public void setIsLastPart(Object value) {
        this.isLastPart = value;
    }

    public void setKey(Object value) {
        this.key = value;
    }

    public void setPartNumber(Object value) {
        this.partNumber = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final String _transformedBucketName = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_bucketNameType").getGenericType(), null, this.bucketName);
        final String _transformedKey = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_keyType").getGenericType(), null, this.key);
        final String _transformedUploadId = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_uploadIdType").getGenericType(), null, this.uploadId);
        final Integer _transformedPartNumber = (Integer)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_partNumberType").getGenericType(), null, this.partNumber);
        final Long _transformedPartSize = (Long)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_partSizeType").getGenericType(), null, this.partSize);
        final String _transformedMd5Digest = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_md5DigestType").getGenericType(), null, this.md5Digest);
        final InputStream _transformedContent = (InputStream)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_contentType").getGenericType(), null, this.content);
        final File _transformedFile = (File)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_fileType").getGenericType(), null, this.file);
        final Long _transformedFileOffset = (Long)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_fileOffsetType").getGenericType(), null, this.fileOffset);
        final Boolean _transformedIsLastPart = (Boolean)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartMessageProcessor.class.getDeclaredField("_isLastPartType").getGenericType(), null, this.isLastPart);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return Arrays.asList(S3ClientException.class);
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                try {
                    return ((S3Connector)object).uploadPart(_transformedBucketName, _transformedKey, _transformedUploadId, _transformedPartNumber, _transformedPartSize, _transformedMd5Digest, _transformedContent, _transformedFile, _transformedFileOffset, _transformedIsLastPart);
                }
                catch (Exception e) {
                    ExceptionDecorator handler = new ExceptionDecorator();
                    handler.handleException(e);
                    throw e;
                }
            }
        }, (MessageProcessor)this, event);
        event.getMessage().setPayload(resultPayload);
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        return new DefaultResult(null, Result.Status.SUCCESS);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult((Object)new DefaultMetaData(this.getPojoOrSimpleModel(UploadPartResult.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at S3Connector at uploadPart retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

