/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.processors;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.s3.S3Connector;
import org.mule.module.s3.exception.ExceptionDecorator;
import org.mule.module.s3.exception.S3ClientException;
import org.mule.module.s3.model.CopyPartResult;
import org.mule.security.oauth.callback.ProcessCallback;

public class UploadPartCopyMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object sourceBucketName;
    protected String _sourceBucketNameType;
    protected Object sourceKey;
    protected String _sourceKeyType;
    protected Object sourceVersionId;
    protected String _sourceVersionIdType;
    protected Object destinationBucketName;
    protected String _destinationBucketNameType;
    protected Object destinationKey;
    protected String _destinationKeyType;
    protected Object uploadId;
    protected String _uploadIdType;
    protected Object partNumber;
    protected Integer _partNumberType;
    protected Object matchingETagConstraints;
    protected List<String> _matchingETagConstraintsType;
    protected Object modifiedSince;
    protected Date _modifiedSinceType;
    protected Object unmodifiedSince;
    protected Date _unmodifiedSinceType;

    public UploadPartCopyMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setSourceKey(Object value) {
        this.sourceKey = value;
    }

    public void setUnmodifiedSince(Object value) {
        this.unmodifiedSince = value;
    }

    public void setDestinationKey(Object value) {
        this.destinationKey = value;
    }

    public void setUploadId(Object value) {
        this.uploadId = value;
    }

    public void setModifiedSince(Object value) {
        this.modifiedSince = value;
    }

    public void setSourceBucketName(Object value) {
        this.sourceBucketName = value;
    }

    public void setDestinationBucketName(Object value) {
        this.destinationBucketName = value;
    }

    public void setSourceVersionId(Object value) {
        this.sourceVersionId = value;
    }

    public void setMatchingETagConstraints(Object value) {
        this.matchingETagConstraints = value;
    }

    public void setPartNumber(Object value) {
        this.partNumber = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final String _transformedSourceBucketName = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_sourceBucketNameType").getGenericType(), null, this.sourceBucketName);
        final String _transformedSourceKey = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_sourceKeyType").getGenericType(), null, this.sourceKey);
        final String _transformedSourceVersionId = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_sourceVersionIdType").getGenericType(), null, this.sourceVersionId);
        final String _transformedDestinationBucketName = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_destinationBucketNameType").getGenericType(), null, this.destinationBucketName);
        final String _transformedDestinationKey = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_destinationKeyType").getGenericType(), null, this.destinationKey);
        final String _transformedUploadId = (String)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_uploadIdType").getGenericType(), null, this.uploadId);
        final Integer _transformedPartNumber = (Integer)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_partNumberType").getGenericType(), null, this.partNumber);
        final List _transformedMatchingETagConstraints = (List)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_matchingETagConstraintsType").getGenericType(), null, this.matchingETagConstraints);
        final Date _transformedModifiedSince = (Date)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_modifiedSinceType").getGenericType(), null, this.modifiedSince);
        final Date _transformedUnmodifiedSince = (Date)this.evaluateAndTransform(this.getMuleContext(), event, UploadPartCopyMessageProcessor.class.getDeclaredField("_unmodifiedSinceType").getGenericType(), null, this.unmodifiedSince);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return Arrays.asList(S3ClientException.class);
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                try {
                    return ((S3Connector)object).uploadPartCopy(_transformedSourceBucketName, _transformedSourceKey, _transformedSourceVersionId, _transformedDestinationBucketName, _transformedDestinationKey, _transformedUploadId, _transformedPartNumber, _transformedMatchingETagConstraints, _transformedModifiedSince, _transformedUnmodifiedSince);
                }
                catch (Exception e) {
                    ExceptionDecorator handler = new ExceptionDecorator();
                    handler.handleException(e);
                    throw e;
                }
            }
        }, (MessageProcessor)this, event);
        event.getMessage().setPayload(resultPayload);
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        return new DefaultResult(null, Result.Status.SUCCESS);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        return new DefaultResult((Object)new DefaultMetaData(this.getPojoOrSimpleModel(CopyPartResult.class)));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at S3Connector at uploadPartCopy retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

