/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.model.content;

import com.amazonaws.1.9.39.shade.services.s3.model.ObjectMetadata;
import com.amazonaws.1.9.39.shade.services.s3.model.PutObjectRequest;
import java.io.InputStream;
import javax.validation.constraints.NotNull;
import org.mule.module.s3.model.content.S3ObjectContent;
import org.mule.module.s3.util.S3ContentUtils;

public class InputStreamS3ObjectContent
implements S3ObjectContent {
    private final InputStream inputStream;
    private final long length;
    private final String md5base64;

    public InputStreamS3ObjectContent(@NotNull InputStream inputStream, Long length, String md5base64) {
        this.inputStream = inputStream;
        this.length = S3ContentUtils.coalesce(length, 0L);
        this.md5base64 = md5base64;
    }

    @Override
    public PutObjectRequest createPutObjectRequest() {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(this.length);
        if (this.md5base64 != null) {
            metadata.setContentMD5(this.md5base64);
        }
        return new PutObjectRequest(null, null, this.inputStream, metadata);
    }
}

