/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NotificationConfiguration
implements Serializable {
    private static final long serialVersionUID = -6529514242605481475L;
    private Set<String> events = new HashSet<String>();
    private List<String> objectPrefixes = new ArrayList<String>();

    public NotificationConfiguration(String ... events) {
        if (events != null) {
            for (String event : events) {
                this.events.add(event);
            }
        }
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public void setEvents(Set<String> events) {
        this.events = events;
    }

    public List<String> getObjectPrefixes() {
        return this.objectPrefixes;
    }

    public void setObjectPrefixes(List<String> objectPrefixes) {
        this.objectPrefixes = objectPrefixes;
    }

    public NotificationConfiguration withEvents(Set<String> events) {
        this.events.clear();
        this.events.addAll(events);
        return this;
    }

    public NotificationConfiguration withObjectPrefixes(String ... objectPrefixes) {
        this.objectPrefixes.clear();
        if (objectPrefixes != null && objectPrefixes.length > 0) {
            this.objectPrefixes.addAll(Arrays.asList(objectPrefixes));
        }
        return this;
    }

    public void addEvent(String event) {
        this.events.add(event);
    }

    public void addObjectPrefix(String prefix) {
        this.objectPrefixes.add(prefix);
    }
}

