/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CORSRule
implements Serializable {
    private static final long serialVersionUID = 6653330903388159693L;
    private String id;
    private List<AllowedMethods> allowedMethods = new ArrayList<AllowedMethods>(0);
    private List<String> allowedOrigins = new ArrayList<String>(0);
    private int maxAgeSeconds;
    private List<String> exposedHeaders = new ArrayList<String>(0);
    private List<String> allowedHeaders = new ArrayList<String>(0);

    public CORSRule(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CORSRule withId(String id) {
        this.id = id;
        return this;
    }

    public void setAllowedMethods(List<AllowedMethods> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public List<AllowedMethods> getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(AllowedMethods ... allowedMethods) {
        this.allowedMethods = Arrays.asList(allowedMethods);
    }

    public CORSRule withAllowedMethods(List<AllowedMethods> allowedMethods) {
        this.allowedMethods = allowedMethods;
        return this;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(String ... allowedOrigins) {
        this.allowedOrigins = Arrays.asList(allowedOrigins);
    }

    public CORSRule withAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public CORSRule withMaxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
        return this;
    }

    public void setExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public void setExposedHeaders(String ... exposedHeaders) {
        this.exposedHeaders = Arrays.asList(exposedHeaders);
    }

    public CORSRule withExposedHeaders(List<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }

    public void setAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public void setAllowedHeaders(String ... allowedHeaders) {
        this.allowedHeaders = Arrays.asList(allowedHeaders);
    }

    public CORSRule withAllowedHeaders(List<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public static enum AllowedMethods {
        GET("GET"),
        PUT("PUT"),
        HEAD("HEAD"),
        POST("POST"),
        DELETE("DELETE");

        private final String allowedMethod;

        private AllowedMethods(String allowedMethod) {
            this.allowedMethod = allowedMethod;
        }

        public static AllowedMethods fromValue(String allowedMethod) throws IllegalArgumentException {
            for (AllowedMethods method : AllowedMethods.values()) {
                String methodString = method.toString();
                if (!methodString.equals(allowedMethod)) continue;
                return method;
            }
            throw new IllegalArgumentException("Cannot create enum from " + allowedMethod + " value!");
        }

        public String toString() {
            return this.allowedMethod;
        }
    }
}

