/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3;

import com.amazonaws.1.9.39.shade.AmazonWebServiceRequest;
import com.amazonaws.1.9.39.shade.services.s3.AmazonS3;
import com.amazonaws.1.9.39.shade.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.BucketCrossOriginConfiguration;
import com.amazonaws.1.9.39.shade.services.s3.model.BucketLifecycleConfiguration;
import com.amazonaws.1.9.39.shade.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.1.9.39.shade.services.s3.model.BucketPolicy;
import com.amazonaws.1.9.39.shade.services.s3.model.BucketTaggingConfiguration;
import com.amazonaws.1.9.39.shade.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.CopyObjectRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.CopyObjectResult;
import com.amazonaws.1.9.39.shade.services.s3.model.CopyPartRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.CreateBucketRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.GetObjectRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.ListObjectsRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.ListPartsRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.ListVersionsRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.ObjectMetadata;
import com.amazonaws.1.9.39.shade.services.s3.model.PutObjectRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.PutObjectResult;
import com.amazonaws.1.9.39.shade.services.s3.model.S3ObjectId;
import com.amazonaws.1.9.39.shade.services.s3.model.S3ObjectInputStream;
import com.amazonaws.1.9.39.shade.services.s3.model.S3ObjectSummary;
import com.amazonaws.1.9.39.shade.services.s3.model.S3VersionSummary;
import com.amazonaws.1.9.39.shade.services.s3.model.SetBucketLoggingConfigurationRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.UploadPartRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.transformer.DataType;
import org.mule.devkit.3.7.0.api.transformer.DefaultTranformingValue;
import org.mule.devkit.3.7.0.api.transformer.TransformingValue;
import org.mule.module.s3.Config;
import org.mule.module.s3.exception.S3Exception;
import org.mule.module.s3.model.AccessControlList;
import org.mule.module.s3.model.BLCRule;
import org.mule.module.s3.model.Bucket;
import org.mule.module.s3.model.BucketLoggingConfiguration;
import org.mule.module.s3.model.BucketVersioningConfiguration;
import org.mule.module.s3.model.BucketWebsiteConfiguration;
import org.mule.module.s3.model.CORSRule;
import org.mule.module.s3.model.CannedAccessControlList;
import org.mule.module.s3.model.CompleteMultipartUploadResult;
import org.mule.module.s3.model.ConditionalConstraints;
import org.mule.module.s3.model.CopyPartResult;
import org.mule.module.s3.model.EncodingType;
import org.mule.module.s3.model.HttpMethod;
import org.mule.module.s3.model.KeyVersion;
import org.mule.module.s3.model.MultipartUploadListing;
import org.mule.module.s3.model.ObjectListing;
import org.mule.module.s3.model.ObjectResult;
import org.mule.module.s3.model.PartETag;
import org.mule.module.s3.model.PartListing;
import org.mule.module.s3.model.Region;
import org.mule.module.s3.model.S3Object;
import org.mule.module.s3.model.S3ObjectMetadata;
import org.mule.module.s3.model.StorageClass;
import org.mule.module.s3.model.TagSet;
import org.mule.module.s3.model.TopicConfiguration;
import org.mule.module.s3.model.UploadPartResult;
import org.mule.module.s3.model.VersionListing;
import org.mule.module.s3.model.VersioningStatus;
import org.mule.module.s3.model.content.S3ObjectContent;
import org.mule.module.s3.model.content.TempFileS3ObjectContent;
import org.mule.module.s3.util.S3ContentUtils;
import org.mule.module.s3.util.S3ModelFactory;
import org.mule.transformer.types.DataTypeFactory;

public class S3Connector {
    @NotNull
    private Config config;
    @NotNull
    private AmazonS3 amazonS3;

    public Bucket createBucket(@NotNull String bucketName, Region region, CannedAccessControlList acl) {
        CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName, region.toString());
        createBucketRequest.setCannedAcl(com.amazonaws.1.9.39.shade.services.s3.model.CannedAccessControlList.valueOf(acl.toString()));
        return S3ModelFactory.wrapBucket(this.amazonS3.createBucket(createBucketRequest));
    }

    public void deleteBucket(@NotNull String bucketName, boolean force) {
        ArrayList<DeleteObjectsRequest.KeyVersion> keyVersions = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        if (force) {
            AmazonWebServiceRequest request;
            String versionStatus = this.amazonS3.getBucketVersioningConfiguration(bucketName).getStatus();
            if (!versionStatus.equals("Off")) {
                request = new ListVersionsRequest().withBucketName(bucketName);
                com.amazonaws.1.9.39.shade.services.s3.model.VersionListing versionListing = this.amazonS3.listVersions((ListVersionsRequest)request);
                do {
                    for (S3VersionSummary versionSummary : versionListing.getVersionSummaries()) {
                        keyVersions.add(new DeleteObjectsRequest.KeyVersion(versionSummary.getKey(), versionSummary.getVersionId()));
                    }
                } while ((versionListing = this.amazonS3.listNextBatchOfVersions(versionListing)) != null && versionListing.isTruncated());
            } else {
                request = new ListObjectsRequest().withBucketName(bucketName);
                com.amazonaws.1.9.39.shade.services.s3.model.ObjectListing objectListing = this.amazonS3.listObjects((ListObjectsRequest)request);
                do {
                    for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                        keyVersions.add(new DeleteObjectsRequest.KeyVersion(objectSummary.getKey()));
                    }
                } while ((objectListing = this.amazonS3.listNextBatchOfObjects(objectListing)) != null && objectListing.isTruncated());
            }
            if (!keyVersions.isEmpty()) {
                request = new DeleteObjectsRequest(bucketName).withKeys(keyVersions);
                this.amazonS3.deleteObjects((DeleteObjectsRequest)request);
            }
        }
        this.amazonS3.deleteBucket(bucketName);
    }

    public void deleteBucketCorsConfiguration(@NotNull String bucketName) {
        this.amazonS3.deleteBucketCrossOriginConfiguration(bucketName);
    }

    public void deleteBucketLifecycleConfiguration(@NotNull String bucketName) {
        this.amazonS3.deleteBucketLifecycleConfiguration(bucketName);
    }

    public void deleteBucketPolicy(@NotNull String bucketName) {
        this.amazonS3.deleteBucketPolicy(bucketName);
    }

    public void deleteBucketTaggingConfiguration(@NotNull String bucketName) {
        this.amazonS3.deleteBucketTaggingConfiguration(bucketName);
    }

    public void deleteBucketWebsiteConfiguration(@NotNull String bucketName) {
        this.amazonS3.deleteBucketWebsiteConfiguration(bucketName);
    }

    public List<Bucket> listBuckets() {
        ArrayList<Bucket> bucketList = new ArrayList<Bucket>();
        List<com.amazonaws.1.9.39.shade.services.s3.model.Bucket> buckets = this.amazonS3.listBuckets();
        for (com.amazonaws.1.9.39.shade.services.s3.model.Bucket bucket : buckets) {
            bucketList.add(S3ModelFactory.wrapBucket(bucket));
        }
        return bucketList;
    }

    public AccessControlList getBucketAcl(@NotNull String bucketName) {
        com.amazonaws.1.9.39.shade.services.s3.model.AccessControlList bucketAcl = this.amazonS3.getBucketAcl(bucketName);
        return S3ModelFactory.wrapAccessControlList(bucketAcl);
    }

    public List<CORSRule> getBucketCorsConfiguration(@NotNull String bucketName) {
        BucketCrossOriginConfiguration configuration = this.amazonS3.getBucketCrossOriginConfiguration(bucketName);
        if (configuration == null || configuration.getRules().isEmpty()) {
            return Collections.emptyList();
        }
        return S3ModelFactory.wrapBucketCrossOriginConfigurationRules(configuration.getRules());
    }

    public List<BLCRule> getBucketLifecycleConfiguration(@NotNull String bucketName) {
        BucketLifecycleConfiguration configuration = this.amazonS3.getBucketLifecycleConfiguration(bucketName);
        if (configuration == null || configuration.getRules().isEmpty()) {
            return Collections.emptyList();
        }
        return S3ModelFactory.wrapBucketLifecycleRules(configuration.getRules());
    }

    public String getBucketPolicy(@NotNull String bucketName) {
        BucketPolicy bucketPolicy = this.amazonS3.getBucketPolicy(bucketName);
        return bucketPolicy.getPolicyText();
    }

    public String getBucketLocation(@NotNull String bucketName) {
        return this.amazonS3.getBucketLocation(bucketName);
    }

    public BucketLoggingConfiguration getBucketLoggingConfiguration(@NotNull String bucketName) {
        com.amazonaws.1.9.39.shade.services.s3.model.BucketLoggingConfiguration conf = this.amazonS3.getBucketLoggingConfiguration(bucketName);
        return new BucketLoggingConfiguration(conf.getDestinationBucketName(), conf.getLogFilePrefix());
    }

    @MetaDataStaticKey(type="TopicConfiguration")
    public Map<String, TopicConfiguration> getBucketNotificationConfiguration(@NotNull String bucketName) {
        BucketNotificationConfiguration configuration = this.amazonS3.getBucketNotificationConfiguration(bucketName);
        return S3ModelFactory.wrapBucketNotification(configuration);
    }

    public List<TagSet> getBucketTaggingConfiguration(@NotNull String bucketName) {
        BucketTaggingConfiguration configuration = this.amazonS3.getBucketTaggingConfiguration(bucketName);
        if (configuration == null || configuration.getAllTagSets().isEmpty()) {
            return Collections.emptyList();
        }
        List<com.amazonaws.1.9.39.shade.services.s3.model.TagSet> allTagSets = configuration.getAllTagSets();
        ArrayList<TagSet> tagSets = new ArrayList<TagSet>(allTagSets.size());
        for (com.amazonaws.1.9.39.shade.services.s3.model.TagSet tagSet : allTagSets) {
            tagSets.add(new TagSet(tagSet.getAllTags()));
        }
        return tagSets;
    }

    public BucketVersioningConfiguration getBucketVersioningConfiguration(@NotNull String bucketName) {
        com.amazonaws.1.9.39.shade.services.s3.model.BucketVersioningConfiguration conf = this.amazonS3.getBucketVersioningConfiguration(bucketName);
        return new BucketVersioningConfiguration(conf.getStatus()).withMfaDeleteEnabled(conf.isMfaDeleteEnabled());
    }

    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(@NotNull String bucketName) {
        com.amazonaws.1.9.39.shade.services.s3.model.BucketWebsiteConfiguration configuration = this.amazonS3.getBucketWebsiteConfiguration(bucketName);
        return S3ModelFactory.wrapBucketWebsiteConfiguration(configuration);
    }

    public void setBucketAcl(@NotNull String bucketName, AccessControlList acl) {
        Validate.notNull((Object)acl, (String)"The AccessControlPolicy parameter must be specified when setting a bucket's ACL");
        this.amazonS3.setBucketAcl(bucketName, S3ModelFactory.unwrapAccessControlList(acl));
    }

    public void setBucketCorsConfiguration(@NotNull String bucketName, @NotNull List<CORSRule> crossOriginConfigurationRules) {
        Validate.notEmpty(crossOriginConfigurationRules, (String)"The Cross Origin Configuration Rules parameter must be specified when setting a bucket's cors");
        List<com.amazonaws.1.9.39.shade.services.s3.model.CORSRule> corsRules = S3ModelFactory.unwrapBucketCrossOriginConfigurationRules(crossOriginConfigurationRules);
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = new BucketCrossOriginConfiguration(corsRules);
        this.amazonS3.setBucketCrossOriginConfiguration(bucketName, bucketCrossOriginConfiguration);
    }

    public void setBucketLifecycleConfiguration(@NotNull String bucketName, @NotNull List<BLCRule> lifecycleConfigurationRules) {
        Validate.notEmpty(lifecycleConfigurationRules, (String)"The LifecycleConfiguration Rules parameter must be specified when setting a bucket's lifeycle");
        List<BucketLifecycleConfiguration.Rule> blcRules = S3ModelFactory.unwrapBucketLifecycleConfigurationRules(lifecycleConfigurationRules);
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration().withRules(blcRules);
        this.amazonS3.setBucketLifecycleConfiguration(bucketName, bucketLifecycleConfiguration);
    }

    public void setBucketPolicy(@NotNull String bucketName, @NotNull String policyText) {
        this.amazonS3.setBucketPolicy(bucketName, policyText);
    }

    public void setBucketLoggingConfiguration(@NotNull String bucketName, @NotNull String destinationBucketName, @NotNull String logFilePrefix) {
        com.amazonaws.1.9.39.shade.services.s3.model.BucketLoggingConfiguration loggingConfiguration = new com.amazonaws.1.9.39.shade.services.s3.model.BucketLoggingConfiguration(destinationBucketName, logFilePrefix);
        SetBucketLoggingConfigurationRequest loggingConfigurationRequest = new SetBucketLoggingConfigurationRequest(bucketName, loggingConfiguration);
        this.amazonS3.setBucketLoggingConfiguration(loggingConfigurationRequest);
    }

    public void setBucketNotificationConfiguration(@NotNull String bucketName, @MetaDataStaticKey(type="TopicConfiguration") Map<String, TopicConfiguration> topicConfigurations) {
        Validate.notEmpty(topicConfigurations, (String)"The TopicConfigurations parameter must be specified when setting a bucket's notifications");
        this.amazonS3.setBucketNotificationConfiguration(bucketName, S3ModelFactory.unwrapBucketNotification(topicConfigurations));
    }

    public void setBucketTaggingConfiguration(@NotNull String bucketName, @NotNull List<TagSet> tagSets) {
        Validate.notEmpty(tagSets, (String)"The TagSets parameter must be specified when setting a bucket's tagging");
        ArrayList<com.amazonaws.1.9.39.shade.services.s3.model.TagSet> tags = new ArrayList<com.amazonaws.1.9.39.shade.services.s3.model.TagSet>(tagSets.size());
        for (TagSet tagSet : tagSets) {
            tags.add(new com.amazonaws.1.9.39.shade.services.s3.model.TagSet(tagSet.getAllTags()));
        }
        BucketTaggingConfiguration taggingConfiguration = new BucketTaggingConfiguration(tags);
        this.amazonS3.setBucketTaggingConfiguration(bucketName, taggingConfiguration);
    }

    public void setBucketWebsiteConfiguration(@NotNull String bucketName, BucketWebsiteConfiguration bucketWebsiteConfiguration) {
        Validate.notNull((Object)bucketWebsiteConfiguration, (String)"The BucketWebsiteConfiguration parameter must be specified when setting a bucket's website configuration");
        this.amazonS3.setBucketWebsiteConfiguration(bucketName, S3ModelFactory.unwrapBucketWebsiteConfiguration(bucketWebsiteConfiguration));
    }

    public void setBucketVersioningConfiguration(@NotNull String bucketName, VersioningStatus status) {
        this.amazonS3.setBucketVersioningConfiguration(new SetBucketVersioningConfigurationRequest(bucketName, new com.amazonaws.1.9.39.shade.services.s3.model.BucketVersioningConfiguration(status.toString())));
    }

    public ObjectResult createObject(@NotNull String bucketName, String key, Object content, Long contentLength, String contentMd5, String contentType, String contentDisposition, CannedAccessControlList acl, StorageClass storageClass, Map<String, String> userMetadata, String encryption) throws IOException {
        S3ObjectContent s3Content = S3ContentUtils.createContent(content, contentLength, contentMd5);
        S3ObjectId objectId = new S3ObjectId(bucketName, key);
        PutObjectRequest request = s3Content.createPutObjectRequest();
        request.setBucketName(bucketName);
        request.setKey(objectId.getKey());
        request.setCannedAcl(com.amazonaws.1.9.39.shade.services.s3.model.CannedAccessControlList.valueOf(acl.toString()));
        if (request.getMetadata() != null) {
            request.getMetadata().setContentType(contentType);
            if (StringUtils.isNotBlank((String)contentDisposition)) {
                request.getMetadata().setContentDisposition(contentDisposition);
            }
            if (encryption != null) {
                request.getMetadata().setSSEAlgorithm(encryption);
            }
        }
        request.getMetadata().setUserMetadata(userMetadata);
        if (storageClass != null) {
            request.setStorageClass(com.amazonaws.1.9.39.shade.services.s3.model.StorageClass.fromValue(storageClass.toString()));
        }
        PutObjectResult result = this.amazonS3.putObject(request);
        if (s3Content instanceof TempFileS3ObjectContent) {
            ((TempFileS3ObjectContent)s3Content).delete();
        }
        return new ObjectResult(result.getETag(), result.getVersionId());
    }

    public void deleteObject(@NotNull String bucketName, @NotNull String key, String versionId) {
        if (!StringUtils.isBlank((String)versionId)) {
            this.amazonS3.deleteVersion(bucketName, key, versionId);
        } else {
            this.amazonS3.deleteObject(bucketName, key);
        }
    }

    public void deleteObjects(@NotNull String bucketName, @NotNull List<KeyVersion> keys) {
        if (keys != null && !keys.isEmpty()) {
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
            ArrayList<DeleteObjectsRequest.KeyVersion> deleteKeysRequest = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            for (KeyVersion key : keys) {
                deleteKeysRequest.add(new DeleteObjectsRequest.KeyVersion(key.getValue(), key.getVersion()));
            }
            deleteObjectsRequest.setKeys(deleteKeysRequest);
            this.amazonS3.deleteObjects(deleteObjectsRequest);
        }
    }

    public ObjectListing listObjects(@NotNull String bucketName, String prefix, String marker, String delimiter, Integer maxKeys, EncodingType encodingType) {
        ListObjectsRequest request = new ListObjectsRequest(bucketName, prefix, marker, delimiter, maxKeys).withEncodingType(encodingType.getValue());
        return S3ModelFactory.wrapObjectListing(this.amazonS3.listObjects(request));
    }

    public ObjectListing listNextBatchOfObjects(@NotNull ObjectListing previousObjectListing) {
        com.amazonaws.1.9.39.shade.services.s3.model.ObjectListing unwrapObject = S3ModelFactory.unwrapObjectListing(previousObjectListing);
        return S3ModelFactory.wrapObjectListing(this.amazonS3.listNextBatchOfObjects(unwrapObject));
    }

    public VersionListing listVersions(@NotNull String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxResults, EncodingType encodingType) {
        ListVersionsRequest request = new ListVersionsRequest(bucketName, prefix, keyMarker, versionIdMarker, delimiter, maxResults).withEncodingType(encodingType.getValue());
        return S3ModelFactory.wrapVersionListing(this.amazonS3.listVersions(request));
    }

    public VersionListing listNextBatchOfVersions(@NotNull VersionListing previousVersionListing) {
        com.amazonaws.1.9.39.shade.services.s3.model.VersionListing unwrapVersion = S3ModelFactory.unwrapVersionListing(previousVersionListing);
        return S3ModelFactory.wrapVersionListing(this.amazonS3.listNextBatchOfVersions(unwrapVersion));
    }

    public void setObjectStorageClass(@NotNull String bucketName, @NotNull String key, StorageClass storageClass) {
        this.amazonS3.changeObjectStorageClass(bucketName, key, com.amazonaws.1.9.39.shade.services.s3.model.StorageClass.fromValue(storageClass.toString()));
    }

    public void setObjectAcl(@NotNull String bucketName, @NotNull String key, String versionId, AccessControlList acl) {
        this.amazonS3.setObjectAcl(bucketName, key, versionId, S3ModelFactory.unwrapAccessControlList(acl));
    }

    public ObjectResult copyObject(@NotNull String sourceBucketName, @NotNull String sourceKey, String sourceVersionId, String destinationBucketName, @NotNull String destinationKey, CannedAccessControlList destinationAcl, StorageClass destinationStorageClass, Map<String, String> destinationUserMetadata, Date modifiedSince, Date unmodifiedSince, String encryption) {
        if (StringUtils.isBlank((String)destinationBucketName)) {
            destinationBucketName = sourceBucketName;
        }
        CopyObjectRequest request = new CopyObjectRequest(sourceBucketName, sourceKey, sourceVersionId, destinationBucketName, destinationKey);
        request.setCannedAccessControlList(com.amazonaws.1.9.39.shade.services.s3.model.CannedAccessControlList.valueOf(destinationAcl.toString()));
        if (destinationStorageClass != null) {
            request.setStorageClass(com.amazonaws.1.9.39.shade.services.s3.model.StorageClass.fromValue(destinationStorageClass.toString()));
        }
        request.setNewObjectMetadata(new ObjectMetadata());
        if (encryption != null) {
            request.getNewObjectMetadata().setSSEAlgorithm(encryption);
        }
        if (destinationUserMetadata != null && !destinationUserMetadata.isEmpty()) {
            request.getNewObjectMetadata().setUserMetadata(destinationUserMetadata);
        }
        ConditionalConstraints.from(modifiedSince, unmodifiedSince).populate(request);
        CopyObjectResult result = this.amazonS3.copyObject(request);
        return new ObjectResult(result.getETag(), result.getLastModifiedDate(), result.getVersionId());
    }

    public URI createObjectPresignedUri(@NotNull String bucketName, @NotNull String key, Date expiration, String contentMd5, String contentType, HttpMethod method) {
        GeneratePresignedUrlRequest presignedUrlRequest = new GeneratePresignedUrlRequest(bucketName, key, com.amazonaws.1.9.39.shade.HttpMethod.valueOf(method.name()));
        presignedUrlRequest.setExpiration(expiration);
        presignedUrlRequest.setContentMd5(contentMd5);
        presignedUrlRequest.setContentType(contentType);
        try {
            return this.amazonS3.generatePresignedUrl(presignedUrlRequest).toURI();
        }
        catch (URISyntaxException e) {
            throw new S3Exception("Amazon S3 returned a malformed URI", e);
        }
    }

    public TransformingValue<S3ObjectInputStream, DataType<S3ObjectInputStream>> getObjectContent(@NotNull String bucketName, @NotNull String key, String versionId, Date modifiedSince, Date unmodifiedSince, String mimeType, String encoding) {
        String mimeValue = StringUtils.isBlank((String)mimeType) ? "application/xml" : mimeType;
        String encodingValue = StringUtils.isBlank((String)encoding) ? StandardCharsets.UTF_8.name() : encoding;
        DataType dataType = DataTypeFactory.create(S3ObjectInputStream.class, (String)mimeValue);
        dataType.setEncoding(encodingValue);
        GetObjectRequest request = new GetObjectRequest(bucketName, key, versionId);
        ConditionalConstraints.from(modifiedSince, unmodifiedSince).populate(request);
        S3ObjectInputStream objectInputStream = this.amazonS3.getObject(request).getObjectContent();
        return new DefaultTranformingValue<S3ObjectInputStream, S3ObjectInputStream>(objectInputStream, dataType);
    }

    public S3Object getObject(@NotNull String bucketName, @NotNull String key, String versionId, Date modifiedSince, Date unmodifiedSince) {
        GetObjectRequest request = new GetObjectRequest(bucketName, key, versionId);
        ConditionalConstraints.from(modifiedSince, unmodifiedSince).populate(request);
        return S3ModelFactory.wrapS3Object(this.amazonS3.getObject(request));
    }

    public AccessControlList getObjectAcl(@NotNull String bucketName, @NotNull String key, String versionId) {
        com.amazonaws.1.9.39.shade.services.s3.model.AccessControlList objectAcl = this.amazonS3.getObjectAcl(bucketName, key, versionId);
        return S3ModelFactory.wrapAccessControlList(objectAcl);
    }

    public S3ObjectMetadata getObjectMetadata(@NotNull String bucketName, @NotNull String key, String versionId) {
        ObjectMetadata objectMetadata = this.amazonS3.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key, versionId));
        return S3ModelFactory.wrapS3ObjectMetadata(objectMetadata);
    }

    public String initiateMultipartUpload(@NotNull String bucketName, @NotNull String key, S3ObjectMetadata objectMetadata, CannedAccessControlList acl, StorageClass storageClass, String redirectLocation) {
        InitiateMultipartUploadRequest uploadRequest = new InitiateMultipartUploadRequest(bucketName, key);
        uploadRequest.setCannedACL(com.amazonaws.1.9.39.shade.services.s3.model.CannedAccessControlList.valueOf(acl.toString()));
        uploadRequest.setObjectMetadata(S3ModelFactory.wrapObjectMetaData(objectMetadata));
        uploadRequest.setStorageClass(com.amazonaws.1.9.39.shade.services.s3.model.StorageClass.fromValue(storageClass.toString()));
        uploadRequest.setRedirectLocation(redirectLocation);
        return this.amazonS3.initiateMultipartUpload(uploadRequest).getUploadId();
    }

    public UploadPartResult uploadPart(@NotNull String bucketName, @NotNull String key, @NotNull String uploadId, @NotNull Integer partNumber, @NotNull Long partSize, String md5Digest, InputStream content, File file, Long fileOffset, boolean isLastPart) {
        if (content == null && file == null) {
            throw new S3Exception("A File or InputStream must be specified when uploading part");
        }
        UploadPartRequest uploadPart = new UploadPartRequest();
        uploadPart.setBucketName(bucketName);
        uploadPart.setKey(key);
        uploadPart.setUploadId(uploadId);
        uploadPart.setPartNumber(partNumber);
        uploadPart.setFile(file);
        if (fileOffset != null) {
            uploadPart.setFileOffset(fileOffset);
        }
        uploadPart.setInputStream(content);
        uploadPart.setLastPart(isLastPart);
        uploadPart.setMd5Digest(md5Digest);
        if (partSize != null) {
            uploadPart.setPartSize(partSize);
        }
        return S3ModelFactory.wrapUploadPartResult(this.amazonS3.uploadPart(uploadPart));
    }

    public CopyPartResult uploadPartCopy(@NotNull String sourceBucketName, @NotNull String sourceKey, String sourceVersionId, @NotNull String destinationBucketName, @NotNull String destinationKey, @NotNull String uploadId, @NotNull Integer partNumber, List<String> matchingETagConstraints, Date modifiedSince, Date unmodifiedSince) {
        CopyPartRequest copyPart = new CopyPartRequest();
        copyPart.setSourceBucketName(sourceBucketName);
        copyPart.setSourceKey(sourceKey);
        copyPart.setSourceVersionId(sourceVersionId);
        copyPart.setUploadId(uploadId);
        copyPart.setPartNumber(partNumber);
        copyPart.setDestinationBucketName(destinationBucketName);
        copyPart.setDestinationKey(destinationKey);
        if (matchingETagConstraints != null && !matchingETagConstraints.isEmpty()) {
            copyPart.setMatchingETagConstraints(matchingETagConstraints);
        }
        ConditionalConstraints.from(modifiedSince, unmodifiedSince).populate(copyPart);
        return S3ModelFactory.wrapCopyPartResult(this.amazonS3.copyPart(copyPart));
    }

    public void abortMultipartUpload(@NotNull String bucketName, @NotNull String key, @NotNull String uploadId) {
        this.amazonS3.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, key, uploadId));
    }

    public CompleteMultipartUploadResult completeMultipartUpload(@NotNull String bucketName, @NotNull String key, @NotNull String uploadId, @NotNull List<PartETag> partETags) {
        ArrayList<com.amazonaws.1.9.39.shade.services.s3.model.PartETag> eTags = new ArrayList<com.amazonaws.1.9.39.shade.services.s3.model.PartETag>(partETags.size());
        for (PartETag tag : partETags) {
            eTags.add(new com.amazonaws.1.9.39.shade.services.s3.model.PartETag(tag.getPartNumber(), tag.getETag()));
        }
        CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, eTags);
        return S3ModelFactory.wrapCompleteMultipartUploadResult(this.amazonS3.completeMultipartUpload(completeRequest));
    }

    public MultipartUploadListing listMultipartUploads(@NotNull String bucketName, String delimiter, String encodingType, String keyMarker, Integer maxUploads, String prefix, String uploadIdMarker) {
        ListMultipartUploadsRequest listRequest = new ListMultipartUploadsRequest(bucketName);
        listRequest.setDelimiter(delimiter);
        listRequest.setEncodingType(encodingType);
        listRequest.setKeyMarker(keyMarker);
        listRequest.setMaxUploads(maxUploads);
        listRequest.setPrefix(prefix);
        listRequest.setUploadIdMarker(uploadIdMarker);
        return S3ModelFactory.wrapMultipartUploadListing(this.amazonS3.listMultipartUploads(listRequest));
    }

    public PartListing listParts(@NotNull String bucketName, @NotNull String key, @NotNull String uploadId, String encodingType, Integer maxParts, Integer partNumberMarker) {
        ListPartsRequest listParts = new ListPartsRequest(bucketName, key, uploadId);
        listParts.setEncodingType(encodingType);
        if (maxParts != null) {
            listParts.setMaxParts(maxParts);
        }
        listParts.setPartNumberMarker(partNumberMarker);
        return S3ModelFactory.wrapPartListing(this.amazonS3.listParts(listParts));
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        this.amazonS3 = config.getClient();
    }
}

