/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3;

import com.amazonaws.1.9.39.shade.ClientConfiguration;
import com.amazonaws.1.9.39.shade.Protocol;
import com.amazonaws.1.9.39.shade.auth.BasicAWSCredentials;
import com.amazonaws.1.9.39.shade.services.s3.AmazonS3;
import com.amazonaws.1.9.39.shade.services.s3.AmazonS3Client;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;

public class Config {
    private Protocol protocol;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyDomain;
    private String proxyWorkstation;
    private Integer socketTimeout;
    private Integer connectionTimeout;
    private Integer maxConnections;
    private AmazonS3 client;

    public void connect(String accessKey, String secretKey) throws ConnectionException {
        if (StringUtils.isBlank((String)accessKey) || StringUtils.isBlank((String)secretKey)) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "001", "Access Key or Secret Key is blank");
        }
        try {
            if (this.getClient() == null) {
                this.setClient(this.createAmazonS3(accessKey, secretKey));
            }
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "002", e.getMessage(), (Throwable)e);
        }
    }

    public void testConnect(String accessKey, String secretKey) throws ConnectionException {
        this.connect(accessKey, secretKey);
        try {
            this.getClient().getS3AccountOwner();
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "003", e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.getClient() != null) {
            this.setClient(null);
        }
    }

    public boolean isConnected() {
        return this.getClient() != null;
    }

    public String connectionId() {
        return "amazon_s3-";
    }

    private AmazonS3 createAmazonS3(String accessKey, String secretKey) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (StringUtils.isNotBlank((String)this.getProxyUsername())) {
            clientConfig.setProxyUsername(this.getProxyUsername());
        }
        if (this.getProxyPort() != null) {
            clientConfig.setProxyPort(this.getProxyPort());
        }
        if (StringUtils.isNotBlank((String)this.getProxyPassword())) {
            clientConfig.setProxyPassword(this.getProxyPassword());
        }
        if (StringUtils.isNotBlank((String)this.getProxyHost())) {
            clientConfig.setProxyHost(this.getProxyHost());
        }
        if (StringUtils.isNotBlank((String)this.getProxyDomain())) {
            clientConfig.setProxyDomain(this.getProxyDomain());
        }
        if (StringUtils.isNotBlank((String)this.getProxyWorkstation())) {
            clientConfig.setProxyWorkstation(this.getProxyWorkstation());
        }
        if (this.getProtocol() != null) {
            clientConfig.setProtocol(this.getProtocol());
        }
        if (this.getConnectionTimeout() != null) {
            clientConfig.setConnectionTimeout(this.getConnectionTimeout());
        }
        if (this.getSocketTimeout() != null) {
            clientConfig.setSocketTimeout(this.getSocketTimeout());
        }
        if (this.getMaxConnections() != null) {
            clientConfig.setMaxConnections(this.getMaxConnections());
        }
        AmazonS3Client amazonS3Client = new AmazonS3Client(new BasicAWSCredentials(accessKey, secretKey), clientConfig);
        return amazonS3Client;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public AmazonS3 getClient() {
        return this.client;
    }

    public void setClient(AmazonS3 client) {
        this.client = client;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }
}

