/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.protocol;

import java.io.IOException;
import org.apache.http.4.3.5.shade.HttpException;
import org.apache.http.4.3.5.shade.HttpResponse;
import org.apache.http.4.3.5.shade.HttpResponseInterceptor;
import org.apache.http.4.3.5.shade.annotation.ThreadSafe;
import org.apache.http.4.3.5.shade.protocol.HttpContext;
import org.apache.http.4.3.5.shade.protocol.HttpDateGenerator;
import org.apache.http.4.3.5.shade.util.Args;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

