/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.3.5.shade.impl.cookie;

import java.util.Collection;
import org.apache.http.4.3.5.shade.annotation.Immutable;
import org.apache.http.4.3.5.shade.cookie.CookieSpec;
import org.apache.http.4.3.5.shade.cookie.CookieSpecFactory;
import org.apache.http.4.3.5.shade.cookie.CookieSpecProvider;
import org.apache.http.4.3.5.shade.impl.cookie.RFC2965Spec;
import org.apache.http.4.3.5.shade.params.HttpParams;
import org.apache.http.4.3.5.shade.protocol.HttpContext;

@Immutable
public class RFC2965SpecFactory
implements CookieSpecFactory,
CookieSpecProvider {
    private final String[] datepatterns;
    private final boolean oneHeader;

    public RFC2965SpecFactory(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    public RFC2965SpecFactory() {
        this(null, false);
    }

    public CookieSpec newInstance(HttpParams params) {
        if (params != null) {
            String[] patterns = null;
            Collection param = (Collection)params.getParameter("http.protocol.cookie-datepatterns");
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            boolean singleHeader = params.getBooleanParameter("http.protocol.single-cookie-header", false);
            return new RFC2965Spec(patterns, singleHeader);
        }
        return new RFC2965Spec();
    }

    public CookieSpec create(HttpContext context) {
        return new RFC2965Spec(this.datepatterns, this.oneHeader);
    }
}

