/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.s3.transfer.internal;

import com.amazonaws.1.9.39.shade.event.ProgressEventType;
import com.amazonaws.1.9.39.shade.event.ProgressListenerChain;
import com.amazonaws.1.9.39.shade.services.s3.model.GetObjectRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.ObjectMetadata;
import com.amazonaws.1.9.39.shade.services.s3.model.S3Object;
import com.amazonaws.1.9.39.shade.services.s3.transfer.Download;
import com.amazonaws.1.9.39.shade.services.s3.transfer.PersistableDownload;
import com.amazonaws.1.9.39.shade.services.s3.transfer.Transfer;
import com.amazonaws.1.9.39.shade.services.s3.transfer.TransferProgress;
import com.amazonaws.1.9.39.shade.services.s3.transfer.exception.PauseException;
import com.amazonaws.1.9.39.shade.services.s3.transfer.internal.AbstractTransfer;
import com.amazonaws.1.9.39.shade.services.s3.transfer.internal.S3ProgressPublisher;
import com.amazonaws.1.9.39.shade.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.1.9.39.shade.services.s3.transfer.internal.TransferStateChangeListener;
import java.io.File;
import java.io.IOException;

public class DownloadImpl
extends AbstractTransfer
implements Download {
    private S3Object s3Object;
    private final PersistableDownload persistableDownload;

    public DownloadImpl(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, S3Object s3Object, TransferStateChangeListener listener, GetObjectRequest getObjectRequest, File file) {
        super(description, transferProgress, progressListenerChain, listener);
        this.s3Object = s3Object;
        this.persistableDownload = this.captureDownloadState(getObjectRequest, file);
        S3ProgressPublisher.publishTransferPersistable(progressListenerChain, this.persistableDownload);
    }

    @Override
    public ObjectMetadata getObjectMetadata() {
        return this.s3Object.getObjectMetadata();
    }

    @Override
    public String getBucketName() {
        return this.s3Object.getBucketName();
    }

    @Override
    public String getKey() {
        return this.s3Object.getKey();
    }

    @Override
    public synchronized void abort() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.s3Object != null) {
            this.s3Object.getObjectContent().abort();
        }
        this.setState(Transfer.TransferState.Canceled);
    }

    public synchronized void abortWithoutNotifyingStateChangeListener() throws IOException {
        this.monitor.getFuture().cancel(true);
        this.state = Transfer.TransferState.Canceled;
    }

    public synchronized void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    @Override
    public void setState(Transfer.TransferState state) {
        super.setState(state);
        if (state == Transfer.TransferState.Completed) {
            this.fireProgressEvent(ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    private PersistableDownload captureDownloadState(GetObjectRequest getObjectRequest, File file) {
        if (getObjectRequest.getSSECustomerKey() == null) {
            return new PersistableDownload(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest.getVersionId(), getObjectRequest.getRange(), getObjectRequest.getResponseHeaders(), getObjectRequest.isRequesterPays(), file.getAbsolutePath());
        }
        return null;
    }

    @Override
    public PersistableDownload pause() throws PauseException {
        boolean forceCancel = true;
        Transfer.TransferState currentState = this.getState();
        this.monitor.getFuture().cancel(true);
        if (this.persistableDownload == null) {
            throw new PauseException(TransferManagerUtils.determinePauseStatus(currentState, forceCancel));
        }
        return this.persistableDownload;
    }
}

