/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.s3.model;

import com.amazonaws.1.9.39.shade.internal.MetricAware;
import com.amazonaws.1.9.39.shade.internal.SdkFilterInputStream;
import com.amazonaws.1.9.39.shade.metrics.AwsSdkMetrics;
import com.amazonaws.1.9.39.shade.metrics.MetricFilterInputStream;
import com.amazonaws.1.9.39.shade.services.s3.metrics.S3ServiceMetric;
import com.amazonaws.1.9.39.shade.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.4.3.5.shade.client.methods.HttpRequestBase;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest) {
        this(in, httpRequest, S3ObjectInputStream.wrapWithByteCounting(in));
    }

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest, boolean collectMetrics) {
        super(collectMetrics ? new MetricFilterInputStream(S3ServiceMetric.S3DownloadThroughput, in) : in);
        this.httpRequest = httpRequest;
    }

    private static boolean wrapWithByteCounting(InputStream in) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (in instanceof MetricAware) {
            MetricAware aware = (MetricAware)((Object)in);
            return !aware.isMetricActivated();
        }
        return true;
    }

    @Override
    public void abort() {
        this.getHttpRequest().abort();
        IOUtils.closeQuietly(this.in, null);
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public int available() throws IOException {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }
}

