/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.s3.internal;

import com.amazonaws.1.9.39.shade.AmazonWebServiceClient;
import com.amazonaws.1.9.39.shade.auth.RegionAwareSigner;
import com.amazonaws.1.9.39.shade.auth.Signer;
import com.amazonaws.1.9.39.shade.handlers.RequestHandler2;
import com.amazonaws.1.9.39.shade.http.ExecutionContext;
import com.amazonaws.1.9.39.shade.services.s3.AmazonS3Client;
import com.amazonaws.1.9.39.shade.util.AwsHostNameUtils;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3ExecutionContext
extends ExecutionContext {
    private static final Log log = LogFactory.getLog(AmazonS3Client.class);
    private Signer signer;

    public S3ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        super(requestHandler2s, isMetricEnabled, awsClient);
    }

    @Override
    public void setSigner(Signer signer) {
        this.signer = signer;
    }

    @Override
    public Signer getSignerByURI(URI uri) {
        AmazonWebServiceClient awsClient = this.getAwsClient();
        if (awsClient != null && awsClient.getSignerRegionOverride() != null) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName(uri.getHost(), "s3"));
            }
            catch (RuntimeException e) {
                log.warn((Object)("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region"), (Throwable)e);
            }
        }
        return this.signer;
    }
}

