/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.s3.internal;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.ReadLimitInfo;
import com.amazonaws.1.9.39.shade.ResetException;
import com.amazonaws.1.9.39.shade.SignableRequest;
import com.amazonaws.1.9.39.shade.auth.AWS4Signer;
import com.amazonaws.1.9.39.shade.auth.AwsChunkedEncodingInputStream;
import com.amazonaws.1.9.39.shade.auth.internal.AWS4SignerRequestParams;
import com.amazonaws.1.9.39.shade.services.s3.model.PutObjectRequest;
import com.amazonaws.1.9.39.shade.services.s3.model.UploadPartRequest;
import com.amazonaws.1.9.39.shade.util.BinaryUtils;
import java.io.IOException;
import java.io.InputStream;

public class AWSS3V4Signer
extends AWS4Signer {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";

    public AWSS3V4Signer() {
        super(false);
    }

    @Override
    protected void processRequestPayload(SignableRequest<?> request, byte[] signature, byte[] signingKey, AWS4SignerRequestParams signerRequestParams) {
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            AwsChunkedEncodingInputStream chunkEncodededStream = new AwsChunkedEncodingInputStream(request.getContent(), signingKey, signerRequestParams.getFormattedSigningDateTime(), signerRequestParams.getScope(), BinaryUtils.toHex(signature), this);
            request.setContent(chunkEncodededStream);
        }
    }

    @Override
    protected String calculateContentHashPresign(SignableRequest<?> request) {
        return "UNSIGNED-PAYLOAD";
    }

    @Override
    protected String calculateContentHash(SignableRequest<?> request) {
        request.addHeader("x-amz-content-sha256", "required");
        if (AWSS3V4Signer.useChunkEncoding(request)) {
            long originalContentLength;
            String contentLength = request.getHeaders().get("Content-Length");
            if (contentLength != null) {
                originalContentLength = Long.parseLong(contentLength);
            } else {
                try {
                    originalContentLength = AWSS3V4Signer.getContentLength(request);
                }
                catch (IOException e) {
                    throw new AmazonClientException("Cannot get the content-length of the request content.", e);
                }
            }
            request.addHeader("x-amz-decoded-content-length", Long.toString(originalContentLength));
            request.addHeader("Content-Length", Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength)));
            return CONTENT_SHA_256;
        }
        return super.calculateContentHash(request);
    }

    private static boolean useChunkEncoding(SignableRequest<?> request) {
        boolean chunkedEncodingEnabled = false;
        if (request.getOriginalRequestObject() instanceof PutObjectRequest || request.getOriginalRequestObject() instanceof UploadPartRequest) {
            chunkedEncodingEnabled = true;
        }
        return chunkedEncodingEnabled;
    }

    static long getContentLength(SignableRequest<?> request) throws IOException {
        int read;
        InputStream content = request.getContent();
        if (!content.markSupported()) {
            throw new IllegalStateException("Bug: request input stream must have been made mark-and-resettable at this point");
        }
        ReadLimitInfo info = request.getReadLimitInfo();
        int readLimit = info.getReadLimit();
        long contentLength = 0L;
        byte[] tmp = new byte[4096];
        content.mark(readLimit);
        while ((read = content.read(tmp)) != -1) {
            contentLength += (long)read;
        }
        try {
            content.reset();
        }
        catch (IOException ex) {
            throw new ResetException("Failed to reset the input stream", ex);
        }
        return contentLength;
    }
}

