/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.kms.model.transform;

import com.amazonaws.1.9.39.shade.AmazonClientException;
import com.amazonaws.1.9.39.shade.DefaultRequest;
import com.amazonaws.1.9.39.shade.Request;
import com.amazonaws.1.9.39.shade.http.HttpMethodName;
import com.amazonaws.1.9.39.shade.internal.ListWithAutoConstructFlag;
import com.amazonaws.1.9.39.shade.services.kms.model.GenerateDataKeyWithoutPlaintextRequest;
import com.amazonaws.1.9.39.shade.transform.Marshaller;
import com.amazonaws.1.9.39.shade.util.StringInputStream;
import com.amazonaws.1.9.39.shade.util.StringUtils;
import com.amazonaws.1.9.39.shade.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class GenerateDataKeyWithoutPlaintextRequestMarshaller
implements Marshaller<Request<GenerateDataKeyWithoutPlaintextRequest>, GenerateDataKeyWithoutPlaintextRequest> {
    @Override
    public Request<GenerateDataKeyWithoutPlaintextRequest> marshall(GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest) {
        if (generateDataKeyWithoutPlaintextRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GenerateDataKeyWithoutPlaintextRequest> request = new DefaultRequest<GenerateDataKeyWithoutPlaintextRequest>(generateDataKeyWithoutPlaintextRequest, "AWSKMS");
        String target = "TrentService.GenerateDataKeyWithoutPlaintext";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (generateDataKeyWithoutPlaintextRequest.getKeyId() != null) {
                jsonWriter.key("KeyId").value(generateDataKeyWithoutPlaintextRequest.getKeyId());
            }
            if (generateDataKeyWithoutPlaintextRequest.getEncryptionContext() != null && !generateDataKeyWithoutPlaintextRequest.getEncryptionContext().isEmpty()) {
                jsonWriter.key("EncryptionContext");
                jsonWriter.object();
                for (Map.Entry<String, String> encryptionContextListValue : generateDataKeyWithoutPlaintextRequest.getEncryptionContext().entrySet()) {
                    if (encryptionContextListValue.getValue() == null) continue;
                    jsonWriter.key(encryptionContextListValue.getKey());
                    jsonWriter.value(encryptionContextListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (generateDataKeyWithoutPlaintextRequest.getKeySpec() != null) {
                jsonWriter.key("KeySpec").value(generateDataKeyWithoutPlaintextRequest.getKeySpec());
            }
            if (generateDataKeyWithoutPlaintextRequest.getNumberOfBytes() != null) {
                jsonWriter.key("NumberOfBytes").value(generateDataKeyWithoutPlaintextRequest.getNumberOfBytes());
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)generateDataKeyWithoutPlaintextRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value(grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

