/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.kms.model;

import com.amazonaws.1.9.39.shade.internal.ListWithAutoConstructFlag;
import com.amazonaws.1.9.39.shade.services.kms.model.KeyListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListKeysResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<KeyListEntry> keys;
    private String nextMarker;
    private Boolean truncated;

    public List<KeyListEntry> getKeys() {
        if (this.keys == null) {
            this.keys = new ListWithAutoConstructFlag();
            this.keys.setAutoConstruct(true);
        }
        return this.keys;
    }

    public void setKeys(Collection<KeyListEntry> keys) {
        if (keys == null) {
            this.keys = null;
            return;
        }
        ListWithAutoConstructFlag keysCopy = new ListWithAutoConstructFlag(keys.size());
        keysCopy.addAll(keys);
        this.keys = keysCopy;
    }

    public ListKeysResult withKeys(KeyListEntry ... keys) {
        if (this.getKeys() == null) {
            this.setKeys(new ArrayList<KeyListEntry>(keys.length));
        }
        for (KeyListEntry value : keys) {
            this.getKeys().add(value);
        }
        return this;
    }

    public ListKeysResult withKeys(Collection<KeyListEntry> keys) {
        if (keys == null) {
            this.keys = null;
        } else {
            ListWithAutoConstructFlag keysCopy = new ListWithAutoConstructFlag(keys.size());
            keysCopy.addAll(keys);
            this.keys = keysCopy;
        }
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListKeysResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public ListKeysResult withTruncated(Boolean truncated) {
        this.truncated = truncated;
        return this;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeys() != null) {
            sb.append("Keys: " + this.getKeys() + ",");
        }
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("Truncated: " + this.isTruncated());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeys() == null ? 0 : this.getKeys().hashCode());
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeysResult)) {
            return false;
        }
        ListKeysResult other = (ListKeysResult)obj;
        if (other.getKeys() == null ^ this.getKeys() == null) {
            return false;
        }
        if (other.getKeys() != null && !other.getKeys().equals(this.getKeys())) {
            return false;
        }
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        return other.isTruncated() == null || other.isTruncated().equals(this.isTruncated());
    }

    public ListKeysResult clone() {
        try {
            return (ListKeysResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

