/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.9.39.shade.services.kms.model;

import com.amazonaws.1.9.39.shade.internal.ListWithAutoConstructFlag;
import com.amazonaws.1.9.39.shade.services.kms.model.GrantConstraints;
import com.amazonaws.1.9.39.shade.services.kms.model.GrantOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GrantListEntry
implements Serializable,
Cloneable {
    private String grantId;
    private String granteePrincipal;
    private String retiringPrincipal;
    private String issuingAccount;
    private ListWithAutoConstructFlag<String> operations;
    private GrantConstraints constraints;

    public String getGrantId() {
        return this.grantId;
    }

    public void setGrantId(String grantId) {
        this.grantId = grantId;
    }

    public GrantListEntry withGrantId(String grantId) {
        this.grantId = grantId;
        return this;
    }

    public String getGranteePrincipal() {
        return this.granteePrincipal;
    }

    public void setGranteePrincipal(String granteePrincipal) {
        this.granteePrincipal = granteePrincipal;
    }

    public GrantListEntry withGranteePrincipal(String granteePrincipal) {
        this.granteePrincipal = granteePrincipal;
        return this;
    }

    public String getRetiringPrincipal() {
        return this.retiringPrincipal;
    }

    public void setRetiringPrincipal(String retiringPrincipal) {
        this.retiringPrincipal = retiringPrincipal;
    }

    public GrantListEntry withRetiringPrincipal(String retiringPrincipal) {
        this.retiringPrincipal = retiringPrincipal;
        return this;
    }

    public String getIssuingAccount() {
        return this.issuingAccount;
    }

    public void setIssuingAccount(String issuingAccount) {
        this.issuingAccount = issuingAccount;
    }

    public GrantListEntry withIssuingAccount(String issuingAccount) {
        this.issuingAccount = issuingAccount;
        return this;
    }

    public List<String> getOperations() {
        if (this.operations == null) {
            this.operations = new ListWithAutoConstructFlag();
            this.operations.setAutoConstruct(true);
        }
        return this.operations;
    }

    public void setOperations(Collection<String> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        ListWithAutoConstructFlag operationsCopy = new ListWithAutoConstructFlag(operations.size());
        operationsCopy.addAll(operations);
        this.operations = operationsCopy;
    }

    public GrantListEntry withOperations(String ... operations) {
        if (this.getOperations() == null) {
            this.setOperations(new ArrayList<String>(operations.length));
        }
        for (String value : operations) {
            this.getOperations().add(value);
        }
        return this;
    }

    public GrantListEntry withOperations(Collection<String> operations) {
        if (operations == null) {
            this.operations = null;
        } else {
            ListWithAutoConstructFlag operationsCopy = new ListWithAutoConstructFlag(operations.size());
            operationsCopy.addAll(operations);
            this.operations = operationsCopy;
        }
        return this;
    }

    public GrantListEntry withOperations(GrantOperation ... operations) {
        ArrayList<String> operationsCopy = new ArrayList<String>(operations.length);
        for (GrantOperation member : operations) {
            operationsCopy.add(member.toString());
        }
        if (this.getOperations() == null) {
            this.setOperations(operationsCopy);
        } else {
            this.getOperations().addAll(operationsCopy);
        }
        return this;
    }

    public GrantConstraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(GrantConstraints constraints) {
        this.constraints = constraints;
    }

    public GrantListEntry withConstraints(GrantConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGrantId() != null) {
            sb.append("GrantId: " + this.getGrantId() + ",");
        }
        if (this.getGranteePrincipal() != null) {
            sb.append("GranteePrincipal: " + this.getGranteePrincipal() + ",");
        }
        if (this.getRetiringPrincipal() != null) {
            sb.append("RetiringPrincipal: " + this.getRetiringPrincipal() + ",");
        }
        if (this.getIssuingAccount() != null) {
            sb.append("IssuingAccount: " + this.getIssuingAccount() + ",");
        }
        if (this.getOperations() != null) {
            sb.append("Operations: " + this.getOperations() + ",");
        }
        if (this.getConstraints() != null) {
            sb.append("Constraints: " + this.getConstraints());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGrantId() == null ? 0 : this.getGrantId().hashCode());
        hashCode = 31 * hashCode + (this.getGranteePrincipal() == null ? 0 : this.getGranteePrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getRetiringPrincipal() == null ? 0 : this.getRetiringPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getIssuingAccount() == null ? 0 : this.getIssuingAccount().hashCode());
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        hashCode = 31 * hashCode + (this.getConstraints() == null ? 0 : this.getConstraints().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantListEntry)) {
            return false;
        }
        GrantListEntry other = (GrantListEntry)obj;
        if (other.getGrantId() == null ^ this.getGrantId() == null) {
            return false;
        }
        if (other.getGrantId() != null && !other.getGrantId().equals(this.getGrantId())) {
            return false;
        }
        if (other.getGranteePrincipal() == null ^ this.getGranteePrincipal() == null) {
            return false;
        }
        if (other.getGranteePrincipal() != null && !other.getGranteePrincipal().equals(this.getGranteePrincipal())) {
            return false;
        }
        if (other.getRetiringPrincipal() == null ^ this.getRetiringPrincipal() == null) {
            return false;
        }
        if (other.getRetiringPrincipal() != null && !other.getRetiringPrincipal().equals(this.getRetiringPrincipal())) {
            return false;
        }
        if (other.getIssuingAccount() == null ^ this.getIssuingAccount() == null) {
            return false;
        }
        if (other.getIssuingAccount() != null && !other.getIssuingAccount().equals(this.getIssuingAccount())) {
            return false;
        }
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (other.getOperations() != null && !other.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (other.getConstraints() == null ^ this.getConstraints() == null) {
            return false;
        }
        return other.getConstraints() == null || other.getConstraints().equals(this.getConstraints());
    }

    public GrantListEntry clone() {
        try {
            return (GrantListEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

