/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.simpleapi;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.ObjectUtils;
import org.mule.module.s3.simpleapi.S3ObjectId;

public enum Region {
    US_STANDARD(com.amazonaws.1_7_13.shade.services.s3.model.Region.US_Standard, "s3.amazonaws.com"),
    US_WEST(com.amazonaws.1_7_13.shade.services.s3.model.Region.US_West, "s3-us-west-1.amazonaws.com"),
    EU_IRELAND(com.amazonaws.1_7_13.shade.services.s3.model.Region.EU_Ireland, "s3-external-1.amazonaws.com"),
    AP_SINGAPORE(com.amazonaws.1_7_13.shade.services.s3.model.Region.AP_Singapore, "s3-ap-southeast-1.amazonaws.com");

    private final com.amazonaws.1_7_13.shade.services.s3.model.Region s3Equivalent;
    private final String domain;

    private Region(com.amazonaws.1_7_13.shade.services.s3.model.Region s3Equivalent, String domain) {
        this.s3Equivalent = s3Equivalent;
        this.domain = domain;
    }

    public com.amazonaws.1_7_13.shade.services.s3.model.Region toS3Equivalent() {
        return this.s3Equivalent;
    }

    public URI getObjectUri(S3ObjectId objectId, boolean secure) {
        String scheme = secure ? "https" : "http";
        try {
            return new URI(String.format("%s://%s.%s/%s", scheme, objectId.getBucketName(), this.domain, objectId.getKey()));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Region getDefaultRegion() {
        return US_STANDARD;
    }

    public static Region from(String location) {
        for (Region region : Region.values()) {
            if (!ObjectUtils.equals((Object)location, (Object)region.toS3Equivalent().toString())) continue;
            return region;
        }
        return US_STANDARD;
    }
}

