/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.simpleapi;

import com.amazonaws.1_7_13.shade.services.s3.model.CopyObjectRequest;
import com.amazonaws.1_7_13.shade.services.s3.model.GetObjectRequest;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;

public final class ConditionalConstraints {
    private static final ConditionalConstraints EMPTY_CONSTRAINTS = new ConditionalConstraints(null, null);
    private final Date modifiedSince;
    private final Date unmodifiedSince;

    private ConditionalConstraints(Date modifiedSince, Date unmodifiedSince) {
        Validate.isTrue((modifiedSince == null || unmodifiedSince == null ? 1 : 0) != 0, (String)"Specify either modifiedSince or umodifiedSince");
        this.modifiedSince = modifiedSince;
        this.unmodifiedSince = unmodifiedSince;
    }

    public void populate(@NotNull GetObjectRequest request) {
        request.setModifiedSinceConstraint(this.modifiedSince);
        request.setUnmodifiedSinceConstraint(this.unmodifiedSince);
    }

    public void populate(@NotNull CopyObjectRequest request) {
        request.setModifiedSinceConstraint(this.modifiedSince);
        request.setUnmodifiedSinceConstraint(this.unmodifiedSince);
    }

    public static ConditionalConstraints from(Date modifiedSince, Date unmodifiedSince) {
        if (modifiedSince == null && unmodifiedSince == null) {
            return EMPTY_CONSTRAINTS;
        }
        return new ConditionalConstraints(modifiedSince, unmodifiedSince);
    }
}

